/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.InterruptedIOException;
import java.nio.channels.SocketChannel;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;

public final class TimeoutInterruptHandler {
    private static final Timer INTERRUPT_TIMER = new Timer("InterruptTimer", true);
    static ConcurrentHashMap<Thread, InterruptTask> outboundTimerTasksHash = new ConcurrentHashMap();
    static ConcurrentHashMap<Thread, InterruptTask> soTimerTasksHash = new ConcurrentHashMap();

    private TimeoutInterruptHandler() {
    }

    public static InterruptTask scheduleInterrupt(InterruptTaskType taskType, int time, Thread threadTobeInterrupted, SocketChannel socketChannel, boolean sendAttn) {
        if (time <= 0) {
            return null;
        }
        ConcurrentHashMap<Thread, InterruptTask> taskMap = TimeoutInterruptHandler.getMap(taskType);
        InterruptTask interruptTask = (InterruptTask)taskMap.get(threadTobeInterrupted);
        if (interruptTask != null) {
            TimeoutInterruptHandler.cancelInterrupt(taskType, threadTobeInterrupted);
        }
        interruptTask = new InterruptTask(threadTobeInterrupted, time, socketChannel, sendAttn);
        INTERRUPT_TIMER.schedule((TimerTask)interruptTask, time);
        taskMap.put(Thread.currentThread(), interruptTask);
        return interruptTask;
    }

    public static InterruptTask scheduleInterrupt(InterruptTaskType taskType, int time, Thread threadTobeInterrupted, SocketChannel socketChannel) {
        return TimeoutInterruptHandler.scheduleInterrupt(taskType, time, threadTobeInterrupted, socketChannel, false);
    }

    public static InterruptTask scheduleInterrupt(InterruptTaskType taskType, int time, Thread threadTobeInterrupted) {
        return TimeoutInterruptHandler.scheduleInterrupt(taskType, time, threadTobeInterrupted, null);
    }

    public static InterruptTask cancelInterrupt(InterruptTaskType taskType, Thread threadTobeInterrupted) {
        ConcurrentHashMap<Thread, InterruptTask> taskMap = TimeoutInterruptHandler.getMap(taskType);
        InterruptTask interruptTask = (InterruptTask)taskMap.remove(threadTobeInterrupted);
        if (interruptTask != null) {
            interruptTask.cancel();
            INTERRUPT_TIMER.purge();
        }
        return interruptTask;
    }

    public static InterruptTask cancelInterrupt(InterruptTaskType taskType, SocketChannel socketChannel) {
        ConcurrentHashMap<Thread, InterruptTask> taskMap = TimeoutInterruptHandler.getMap(taskType);
        InterruptTask interruptTask = taskMap.searchValues(1L, task -> task.isSocketChannel(socketChannel) ? task : null);
        if (interruptTask == null) {
            return null;
        }
        taskMap.remove(interruptTask.getThread());
        interruptTask.cancel();
        INTERRUPT_TIMER.purge();
        return interruptTask;
    }

    public static boolean isInterruptScheduled(InterruptTaskType taskType, Thread threadTobeInterrupted) {
        ConcurrentHashMap<Thread, InterruptTask> taskMap = TimeoutInterruptHandler.getMap(taskType);
        return taskMap.get(threadTobeInterrupted) != null;
    }

    public static void resetTimer(InterruptTaskType taskType, Thread threadTobeInterrupted) {
        ConcurrentHashMap<Thread, InterruptTask> taskMap = TimeoutInterruptHandler.getMap(taskType);
        InterruptTask interruptTask = TimeoutInterruptHandler.cancelInterrupt(taskType, threadTobeInterrupted);
        if (interruptTask != null) {
            if (interruptTask.isInterrupted) {
                Thread.interrupted();
            }
            TimeoutInterruptHandler.scheduleInterrupt(taskType, interruptTask.time, threadTobeInterrupted, interruptTask.socketChannel, interruptTask.sendAttn);
        }
    }

    private static ConcurrentHashMap<Thread, InterruptTask> getMap(InterruptTaskType taskType) {
        if (taskType.compareTo(InterruptTaskType.OUTBOUND_TIMEOUT) == 0) {
            return outboundTimerTasksHash;
        }
        return soTimerTasksHash;
    }

    public static void stopTimer() {
        INTERRUPT_TIMER.cancel();
    }

    public static TimerTask scheduleTask(Runnable task, long msDelay) {
        TimerPurgingTask purgingTask = new TimerPurgingTask(task);
        INTERRUPT_TIMER.schedule((TimerTask)purgingTask, msDelay);
        return purgingTask;
    }

    public static TimerTask scheduleFixedDelayRepeatingTask(Runnable task, long periodOfMilliseconds) {
        TimerPurgingTask purgingTask = new TimerPurgingTask(task);
        INTERRUPT_TIMER.schedule((TimerTask)purgingTask, 0L, periodOfMilliseconds);
        return purgingTask;
    }

    public static void scheduleAtFixedRate(TimerTask task, long delay, long period) {
        INTERRUPT_TIMER.scheduleAtFixedRate(task, delay, period);
    }

    private static final class TimerPurgingTask
    extends TimerTask {
        private static final String CLASS_NAME = TimerPurgingTask.class.getName();
        private final Runnable runnableTask;
        private boolean isPurged = false;

        private TimerPurgingTask(Runnable runnableTask) {
            this.runnableTask = runnableTask;
        }

        @Override
        public void run() {
            try {
                this.runnableTask.run();
            }
            catch (Throwable throwable) {
                CommonDiagnosable.getInstance().debug(Level.SEVERE, SecurityLabel.UNKNOWN, CLASS_NAME, "run", "Unexpected exception thrown by timer task", null, throwable);
            }
        }

        @Override
        public boolean cancel() {
            boolean isCancelled = super.cancel();
            if (!this.isPurged) {
                INTERRUPT_TIMER.purge();
                this.isPurged = true;
            }
            return isCancelled;
        }
    }

    public static class IOReadTimeoutException
    extends InterruptedIOException {
        private static final long serialVersionUID = 1L;

        IOReadTimeoutException(String msg) {
            super(msg);
        }
    }

    public static class InterruptTask
    extends TimerTask {
        private final Thread threadTobeInterrupted;
        private volatile boolean isInterrupted = false;
        private final int time;
        private final SocketChannel socketChannel;
        private boolean sendAttn = false;

        public InterruptTask(Thread thread, int time, SocketChannel socketChannel) {
            this.threadTobeInterrupted = thread;
            this.time = time;
            this.socketChannel = socketChannel;
        }

        public InterruptTask(Thread thread, int time, SocketChannel socketChannel, boolean sendAttn) {
            this(thread, time, socketChannel);
            this.sendAttn = sendAttn;
        }

        public boolean isInterrupted() {
            return this.isInterrupted;
        }

        public boolean isSocketChannel(SocketChannel socketChannel) {
            return this.socketChannel == socketChannel;
        }

        public Thread getThread() {
            return this.threadTobeInterrupted;
        }

        private void sendAttentionMarker() {
            if (!this.sendAttn) {
                return;
            }
            try {
                this.socketChannel.socket().sendUrgentData(33);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            this.isInterrupted = true;
            this.sendAttentionMarker();
            this.threadTobeInterrupted.interrupt();
        }
    }

    public static enum InterruptTaskType {
        SO_TIMEOUT,
        OUTBOUND_TIMEOUT;

    }
}

