# Autogenerated.
set(DEFAULT_CUDA_VERSION 12.9)
set(CUDA_VERSIONS 12.9)
set(PROF_SUFFIX x64)
# End autogeneration.

# This cmake file is prepended by a script to populate some hardcoded variables.
# These variables are: DEFAULT_CUDA_VERSION, CUDA_VERSIONS, PROF_SUFFIX.

# 

#[[
  This is a config file provided by HPC SDK for easy integration with CMake
  builds.

  Example:
  project(helloworld CXX)

  set(NVHPC_CUDA_VERSION 11.0)
  find_package(NVHPC REQUIRED COMPONENTS MATH)

  add_executable(helloworld "helloworld.cpp")
  target_link_libraries(helloworld PRIVATE NVHPC::MATH)


  The NVHPC_CUDA_VERSION variable can be set to specify a cuda version. If not
  set it will default to a version that comes with NVHPC.

  Components:
  This config provides components that will load different targets. Specify
  targets through find_package's COMPONENTS parameter. If ALL or no components
  are specified, all components will be loaded. Available components are:

  CUDA - CUDA core libraries (Thrust, CUB, libcu++, cudaRT, etc...).
  MATH - Provides CUDA's math libraries (cuBLAS, cuTENSOR, etc...).
  HOSTUTILS - Provides HPC SDK compiler core libraries and include directories.
  NVSHMEM - Provides the NVSHMEM interface library.
  NCCL - Provides the NCCL communication library.
  MPI - Provides HPC SDK's distribution of OpenMPI.
  PROFILER - Provides Nsight_Systems/target-*/nvtx/include directory.

  Provided targets:
  This config provides IMPORTED targets with the following name conventions:

  NVHPC::{COMPONENT}
  Example: target_link_libraries(helloworld PRIVATE NVHPC::NVSHMEM).

  Link the provided targets to an executable target using target_link_libraries.
  The above example links the HPC SDK math target to the helloworld target,
  which will cause CMake to include the necessary directories and links the
  necessary libraries.

  The HOSTUTILS and MATH component also provides SUBCOMPONENTS to link specific
  libraries. Linking component targets also link all of their subcomponents.
  The naming conventions of subcomponent targets are:

  NVHPC::{SUBCOMPONENT}
  Example: target_link_libraries(helloworld PRIVATE NVHPC::CUBLAS).

  Available subcomponents:
  MATH:
    CUBLAS
    CUTENSOR
    CUSPARSE
    CUSOLVER
    CUFFT
    CUFFTMP
    CURAND
  CUDA:
    NVRTC
    CUDART
]]

cmake_policy(PUSH)
cmake_policy(SET CMP0057 NEW)
set(NVHPC_ROOT_DIR "${CMAKE_CURRENT_LIST_DIR}/..")

function(nvhpc_include_no_system target include_dir)
  cmake_parse_arguments(arg "BEFORE" "" "" ${ARGN})
  if(arg_BEFORE)
    set(BEFORE "BEFORE")
  endif()
  if(CMAKE_VERSION VERSION_GREATER_EQUAL 3.25)
    target_include_directories(${target} ${BEFORE} INTERFACE ${include_dir})
    set_target_properties(${target} PROPERTIES SYSTEM OFF)
  else()
    string(REPLACE ":" "" tmp_target ${target})
    if(NOT TARGET NVHPC_non_system_${tmp_target})
      add_library(NVHPC_non_system_${tmp_target} INTERFACE)
    endif()
    target_include_directories(NVHPC_non_system_${tmp_target} ${BEFORE} INTERFACE ${include_dir})
    target_link_libraries(${target} INTERFACE NVHPC_non_system_${tmp_target})
  endif()
endfunction()

function(nvhpc_add_lib component lib)
  # Create a target for a component with a given compile flag.
  # SUBCOMPONENT: when present, the target's name is
  #   NVHPC::SUBCOMPONENT instead.
  # ADD_TO_COMPONENT, only available when subcomponent is provided, also
  #   create NVHPC::COMPONENT as a target (along with the subcomponent target).
  # DEPS: the list of component this subcomponent is depended on.
  cmake_parse_arguments(arg "ADD_TO_COMPONENT;NOSYSTEM" "SUBCOMPONENT" "DEPS" ${ARGN})

  # Setting up targets.
  string(TOUPPER ${component} component)
  string(TOUPPER ${lib} lib_upper)
  if(arg_SUBCOMPONENT)
    string(TOUPPER ${arg_SUBCOMPONENT} subcomponent)
    set(target ${subcomponent})
  else()
    set(target ${component})
  endif()

  find_library(NVHPC_${lib_upper}_LIBRARY
    NAMES ${lib}
    PATHS ${NVHPC_${component}_LIBRARY_DIR}
    NO_DEFAULT_PATH
  )

  #message(STATUS "NVHPC_${target}_LIBRARY: ${NVHPC_${target}_LIBRARY}")
  if (NOT TARGET NVHPC::${target})
    add_library(NVHPC::${target} IMPORTED INTERFACE)
  endif()

  if (NVHPC_${lib_upper}_LIBRARY)
    target_link_libraries(NVHPC::${target} INTERFACE "${NVHPC_${lib_upper}_LIBRARY}")
    target_link_directories(NVHPC::${target} INTERFACE "${NVHPC_${component}_LIBRARY_DIR}")
    if (arg_NOSYSTEM)
      nvhpc_include_no_system(NVHPC::${target} "${NVHPC_${component}_INCLUDE_DIR}")
    else()
      target_include_directories(NVHPC::${target} INTERFACE "${NVHPC_${component}_INCLUDE_DIR}")
    endif()
  else()
    set(NVHPC_${component}_FOUND FALSE PARENT_SCOPE)
    if(NOT NVHPC_FIND_QUIETLY)
      message(WARNING "Unable to find lib ${lib}\nSearch locations: ${NVHPC_${component}_LIBRARY_DIR}")
    endif()
    return()
  endif()

  foreach(dep ${arg_DEPS})
    string(TOUPPER ${dep} dep)
    if(TARGET NVHPC::${dep})
      target_link_libraries(NVHPC::${target} INTERFACE NVHPC::${dep})
    endif()
  endforeach()

  # Add the target to the overarching component.
  if (arg_ADD_TO_COMPONENT AND NOT target EQUAL component)
    if (NOT TARGET NVHPC::${component})
      add_library(NVHPC::${component} IMPORTED INTERFACE)
    endif()
    target_link_libraries(NVHPC::${component} INTERFACE NVHPC::${target})
  endif()
endfunction()



function(nvhpc_initialize_component component inc_dir lib_dir)
  cmake_parse_arguments(arg "NOSYSTEM" "" "" ${ARGN})
  string(TOUPPER ${component} component)
  set(NVHPC_${component}_FOUND TRUE PARENT_SCOPE)
  if(NOT TARGET NVHPC::${component})
    add_library(NVHPC::${component} IMPORTED INTERFACE)
    if(arg_NOSYSTEM)
      nvhpc_include_no_system(NVHPC::${component} "${inc_dir}")
    else()
      target_include_directories(NVHPC::${component} INTERFACE ${inc_dir})
    endif()
    set(NVHPC_${component}_LIBRARY_DIR ${lib_dir} PARENT_SCOPE)
    set(NVHPC_${component}_INCLUDE_DIR ${inc_dir} PARENT_SCOPE)
  endif()
endfunction()

macro(nvhpc_add_component component)
  string(TOUPPER ${component} component)
  if(NOT TARGET NVHPC::${component})
    if(${component} STREQUAL "HOSTUTILS")
      nvhpc_initialize_component(HOSTUTILS
        "${NVHPC_ROOT_DIR}/compilers/include"
        "${NVHPC_ROOT_DIR}/compilers/lib"
      )
    target_link_directories(NVHPC::HOSTUTILS INTERFACE ${NVHPC_HOSTUTILS_LIBRARY_DIR})

    elseif(${component} STREQUAL "NVSHMEM")
      nvhpc_initialize_component(NVSHMEM
        "${NVHPC_ROOT_DIR}/comm_libs/${NVHPC_CUDA_VERSION}/nvshmem/include"
        "${NVHPC_ROOT_DIR}/comm_libs/${NVHPC_CUDA_VERSION}/nvshmem/lib"
        NOSYSTEM
      )
      nvhpc_add_lib(NVSHMEM nvshmem_host NOSYSTEM)
      nvhpc_add_lib(NVSHMEM nvshmem_device NOSYSTEM)

    elseif(${component} STREQUAL "NCCL")
      nvhpc_initialize_component(NCCL
        "${NVHPC_ROOT_DIR}/comm_libs/${NVHPC_CUDA_VERSION}/nccl/include"
        "${NVHPC_ROOT_DIR}/comm_libs/${NVHPC_CUDA_VERSION}/nccl/lib"
      )
      nvhpc_add_lib(NCCL nccl)

    elseif(${component} STREQUAL "CUDA")
      nvhpc_initialize_component(CUDA
        "${NVHPC_ROOT_DIR}/cuda/${NVHPC_CUDA_VERSION}/include"
        "${NVHPC_ROOT_DIR}/cuda/${NVHPC_CUDA_VERSION}/lib64"
      )
      nvhpc_add_lib(CUDA nvrtc SUBCOMPONENT NVRTC)
      nvhpc_add_lib(CUDA cudart SUBCOMPONENT CUDART)
      nvhpc_add_lib(CUDA cudart_static SUBCOMPONENT CUDART_STATIC)
      nvhpc_add_lib(CUDA culibos SUBCOMPONENT CULIBOS)

    elseif(${component} STREQUAL "MATH")
      if(NOT TARGET NVHPC::CUDA)
        nvhpc_add_component(CUDA)
      endif()
      nvhpc_initialize_component(MATH
        "${NVHPC_ROOT_DIR}/math_libs/${NVHPC_CUDA_VERSION}/include"
        "${NVHPC_ROOT_DIR}/math_libs/${NVHPC_CUDA_VERSION}/lib64"
      )
      foreach(lib IN ITEMS cublas cutensor cusparse cufftMp cufft curand cusolver)
        string(TOUPPER ${lib} lib_upper)

        nvhpc_add_lib(MATH ${lib} SUBCOMPONENT ${lib_upper} ADD_TO_COMPONENT)
        if(TARGET NVHPC::${lib_upper})
          target_include_directories(NVHPC::${lib_upper} INTERFACE "${NVHPC_CUDA_INCLUDE_DIR}")
        endif()
        if(NOT ${lib} STREQUAL "cufftMp")
          nvhpc_add_lib(MATH ${lib}_static SUBCOMPONENT ${lib_upper}_STATIC DEPS CULIBOS)
          if(TARGET NVHPC::${lib_upper}_STATIC)
            target_include_directories(NVHPC::${lib_upper}_STATIC INTERFACE "${NVHPC_CUDA_INCLUDE_DIR}")
          endif()
        endif()

        if(${lib} STREQUAL "cufftMp")
          nvhpc_include_no_system(NVHPC::CUFFTMP "${NVHPC_MATH_INCLUDE_DIR}/cufftmp" BEFORE)
          if(EXISTS "${NVHPC_ROOT_DIR}/comm_libs/${NVHPC_CUDA_VERSION}/nvshmem_cufftmp_compat/include")
            nvhpc_initialize_component(NVSHMEM_COMPAT
              "${NVHPC_ROOT_DIR}/comm_libs/${NVHPC_CUDA_VERSION}/nvshmem_cufftmp_compat/include"
              "${NVHPC_ROOT_DIR}/comm_libs/${NVHPC_CUDA_VERSION}/nvshmem_cufftmp_compat/lib"
              NOSYSTEM)
            nvhpc_add_lib(NVSHMEM_COMPAT nvshmem_host NOSYSTEM)
            nvhpc_add_lib(NVSHMEM_COMPAT nvshmem_device NOSYSTEM)
            if(TARGET NVHPC::NVSHMEM_COMPAT)
              target_link_libraries(NVHPC::CUFFTMP INTERFACE NVHPC::NVSHMEM_COMPAT)
            endif()
          else()
            if(NOT TARGET NVHPC::NVSHMEM)
              nvhpc_add_component(NVSHMEM)
            endif()
            target_link_libraries(NVHPC::CUFFTMP INTERFACE NVHPC::NVSHMEM)
          endif()
        endif()
      endforeach()

    elseif(${component} STREQUAL "PROFILER")
      set(NVHPC_PROFILER_FOUND TRUE)
      set(NVHPC_PROFILER_INCLUDE_DIR "${NVHPC_ROOT_DIR}/profilers/Nsight_Systems/target-linux-${PROF_SUFFIX}/nvtx/include")
      add_library(NVHPC::PROFILER IMPORTED INTERFACE)
      target_include_directories(NVHPC::PROFILER INTERFACE ${NVHPC_PROFILER_INCLUDE_DIR})

    elseif(${component} STREQUAL "MPI")
      nvhpc_initialize_component(MPI
        "${NVHPC_ROOT_DIR}/comm_libs/mpi/include"
        "${NVHPC_ROOT_DIR}/comm_libs/mpi/lib")

      set(MPI_HOME "${NVHPC_ROOT_DIR}/comm_libs/mpi")
      set(MPI_C_COMPILER "${NVHPC_ROOT_DIR}/comm_libs/mpi/bin/mpicc")
      set(MPI_CXX_COMPILER "${NVHPC_ROOT_DIR}/comm_libs/mpi/bin/mpicxx")
      set(MPI_Fortran_COMPILER "${NVHPC_ROOT_DIR}/comm_libs/mpi/bin/mpifort")
      set(MPIEXEC_EXECUTABLE "${NVHPC_ROOT_DIR}/comm_libs/mpi/bin/mpiexec")
      if(NVHPC_FIND_REQUIRED_MPI)
        find_package(MPI REQUIRED ${NVHPC_FIND_QUIETLY})
      else()
        find_package(MPI ${NVHPC_FIND_QUIETLY})
      endif()
      if(MPI_FOUND)
        foreach(LANG IN ITEMS C CXX Fortran)
          if(TARGET MPI::MPI_${LANG} AND NOT TARGET NVHPC::MPI_${LANG})
            add_library(NVHPC::MPI_${LANG} IMPORTED INTERFACE)
            target_link_libraries(NVHPC::MPI_${LANG} INTERFACE MPI::MPI_${LANG})
            target_include_directories(NVHPC::MPI_${LANG} INTERFACE "${MPI_${LANG}_INCLUDE_DIRS}")
          endif()
        endforeach()
      else()
        set(NVHPC_MPI_FOUND FALSE)
      endif()
    endif()
  endif()
endmacro()


if(NOT "cuf" IN_LIST CMAKE_Fortran_SOURCE_FILE_EXTENSION)
  # Compile .cuf files using nvfortran
  list(APPEND CMAKE_Fortran_SOURCE_FILE_EXTENSION "cuf")
endif()

if(NVHPC_FIND_REQUIRED)
  set(NVHPC_FIND_REQUIRED "REQUIRED")
endif()
if(NVHPC_FIND_QUIETLY)
  set(NVHPC_FIND_QUIETLY "QUIET")
endif()

set(AVAILABLE_CUDA_VERSION ${CUDA_VERSIONS})
# User specified a cuda version.
if(NVHPC_CUDA_VERSION)
  foreach(version IN LISTS AVAILABLE_CUDA_VERSION)
    if (${NVHPC_CUDA_VERSION} VERSION_EQUAL ${version})
      set(VERSION_FOUND TRUE)
      # Normalize version.
      set(NVHPC_CUDA_VERSION ${version})
    endif()
  endforeach()
  if(NOT VERSION_FOUND)
    message(FATAL_ERROR "Requested CUDA version not available:"
            " ${NVHPC_CUDA_VERSION}\n"
            "Available versions: ${AVAILABLE_CUDA_VERSION}")
  endif()

  if(NOT NVHPC_FIND_QUIETLY)
    message(STATUS "CUDA version selected: ${NVHPC_CUDA_VERSION}")
  endif()
else()
  set(NVHPC_CUDA_VERSION ${DEFAULT_CUDA_VERSION})
  if(NOT NVHPC_FIND_QUIETLY)
    message(STATUS "NVHPC_CUDA_VERSION not specified.")
    message(STATUS "Default CUDA version selected: ${NVHPC_CUDA_VERSION}")
  endif()
endif()

list(TRANSFORM NVHPC_FIND_COMPONENTS TOUPPER)

# Populate components list when blank or ALL is provided.
if(NOT NVHPC_FIND_COMPONENTS OR "ALL" IN_LIST NVHPC_FIND_COMPONENTS)
  if(NOT NVHPC_FIND_COMPONENTS AND NVHPC_FIND_REQUIRED)
    set(NVHPC_FIND_REQUIRED_ALL TRUE)
  endif()
  set(NVHPC_ALL_COMPONENTS TRUE)
  set(NVHPC_FIND_COMPONENTS "")

  foreach(comp IN ITEMS HOSTUTILS NVSHMEM NCCL MATH CUDA PROFILER MPI)
    list(APPEND NVHPC_FIND_COMPONENTS ${comp})
    if(NVHPC_FIND_REQUIRED_ALL)
      set(NVHPC_FIND_REQUIRED_${comp} TRUE)
    endif()
  endforeach()
endif()

foreach(component IN LISTS NVHPC_FIND_COMPONENTS)
  nvhpc_add_component(${component})
endforeach()


foreach(comp IN LISTS NVHPC_FIND_COMPONENTS)
  if(NOT NVHPC_${comp}_FOUND AND NVHPC_FIND_REQUIRED_${comp})
    message(SEND_ERROR "Can't find required component ${comp}")
  endif()
endforeach()

unset(NVHPC_ALL_COMPONENTS)
unset(AVAILABLE_CUDA_VERSION)
cmake_policy(POP)
