/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo;

import io.quarkus.gizmo.BytecodeCreatorImpl;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.CatchBlockCreatorImpl;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

class TryBlockImpl
extends BytecodeCreatorImpl
implements TryBlock {
    private final LinkedHashMap<String, CatchBlockCreatorImpl> catchBlocks = new LinkedHashMap();

    TryBlockImpl(BytecodeCreatorImpl enclosing) {
        super(enclosing);
    }

    @Override
    public CatchBlockCreator addCatch(String exceptionType) {
        String name = exceptionType.replace('.', '/');
        if (this.catchBlocks.containsKey(name)) {
            throw new IllegalStateException("Catch block for " + name + " already exists");
        }
        CatchBlockCreatorImpl catchBlock = new CatchBlockCreatorImpl(name, this.getOwner());
        this.catchBlocks.put(name, catchBlock);
        return catchBlock;
    }

    @Override
    protected void writeOperations(MethodVisitor visitor) {
        super.writeOperations(visitor);
        if (this.getTop().getOffset() != this.getBottom().getOffset()) {
            Label foot = new Label();
            visitor.visitJumpInsn(167, foot);
            for (Map.Entry<String, CatchBlockCreatorImpl> entry : this.catchBlocks.entrySet()) {
                CatchBlockCreatorImpl value = entry.getValue();
                value.writeOperations(visitor);
                visitor.visitJumpInsn(167, foot);
                visitor.visitTryCatchBlock(this.getTop(), this.getBottom(), value.getTop(), entry.getKey());
            }
            visitor.visitLabel(foot);
        }
    }

    @Override
    void findActiveResultHandles(Set<ResultHandle> handlesToAllocate) {
        super.findActiveResultHandles(handlesToAllocate);
        for (CatchBlockCreatorImpl value : this.catchBlocks.values()) {
            value.findActiveResultHandles(handlesToAllocate);
        }
    }
}

