/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.quota;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Consumer;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;

public class SensorAccess {
    private final ReadWriteLock lock;
    private final Metrics metrics;

    public SensorAccess(ReadWriteLock lock, Metrics metrics) {
        this.lock = lock;
        this.metrics = metrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sensor getOrCreate(String sensorName, long expirationTime, Consumer<Sensor> registerMetrics) {
        Sensor sensor;
        this.lock.readLock().lock();
        try {
            sensor = this.metrics.getSensor(sensorName);
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (sensor == null) {
            this.lock.writeLock().lock();
            try {
                sensor = this.metrics.getSensor(sensorName);
                if (sensor == null) {
                    sensor = this.metrics.sensor(sensorName, null, expirationTime, new Sensor[0]);
                    registerMetrics.accept(sensor);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        return sensor;
    }
}

