/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.nativeintegration.jansi;

import org.gradle.internal.nativeintegration.jansi.DefaultJansiRuntimeResolver;
import org.gradle.internal.nativeintegration.jansi.JansiLibrary;
import org.gradle.internal.nativeintegration.jansi.JansiOperatingSystemSupport;
import org.gradle.internal.nativeintegration.jansi.JansiRuntimeResolver;

public class JansiLibraryFactory {
    public static final String MAC_OSX_LIB_FILENAME = "libjansi.jnilib";
    public static final String LINUX_LIB_FILENAME = "libjansi.so";
    public static final String WINDOWS_LIB_FILENAME = "jansi.dll";
    private JansiRuntimeResolver jansiRuntimeResolver = new DefaultJansiRuntimeResolver();

    void setJansiRuntimeResolver(JansiRuntimeResolver jansiRuntimeResolver) {
        this.jansiRuntimeResolver = jansiRuntimeResolver;
    }

    public JansiLibrary create() {
        String os = this.jansiRuntimeResolver.getOperatingSystem();
        JansiOperatingSystemSupport osSupport = JansiOperatingSystemSupport.forIdentifier(os);
        if (osSupport == null) {
            return null;
        }
        switch (osSupport) {
            case MAC_OS_X: {
                return new JansiLibrary(os, MAC_OSX_LIB_FILENAME);
            }
            case LINUX: {
                return new JansiLibrary(this.jansiRuntimeResolver.getPlatform(), LINUX_LIB_FILENAME);
            }
            case WINDOWS: {
                return new JansiLibrary(this.jansiRuntimeResolver.getPlatform(), WINDOWS_LIB_FILENAME);
            }
        }
        return null;
    }
}

