/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.push.PushTargetPanel;
import com.intellij.dvcs.push.ui.PushLogTreeUtil;
import com.intellij.dvcs.push.ui.PushTargetEditorListener;
import com.intellij.dvcs.push.ui.PushTargetTextField;
import com.intellij.dvcs.push.ui.VcsEditableTextComponent;
import com.intellij.dvcs.push.ui.VcsLinkListener;
import com.intellij.dvcs.push.ui.VcsLinkedTextComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TextIcon;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.ComponentsListFocusTraversalPolicy;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.i18n.GitBundle;
import git4idea.push.GitPushSource;
import git4idea.push.GitPushSupport;
import git4idea.push.GitPushTarget;
import git4idea.push.GitPushTargetType;
import git4idea.remote.GitDefineRemoteDialog;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.validators.GitRefNameValidator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitPushTargetPanel
extends PushTargetPanel<GitPushTarget> {
    private static final Logger LOG = Logger.getInstance(GitPushTargetPanel.class);
    private static final Comparator<GitRemoteBranch> REMOTE_BRANCH_COMPARATOR = new MyRemoteBranchComparator();
    private static final String SEPARATOR = " : ";
    @NotNull
    private final GitPushSupport myPushSupport;
    @NotNull
    private final GitRepository myRepository;
    @NotNull
    private final GitPushSource mySource;
    @NotNull
    private final Git myGit;
    @NotNull
    private final VcsEditableTextComponent myTargetRenderer;
    @NotNull
    private final PushTargetTextField myTargetEditor;
    @NotNull
    private final VcsLinkedTextComponent myRemoteRenderer;
    @NotNull
    private final Project myProject;
    @Nullable
    private final SetUpstreamCheckbox myUpstreamCheckbox;
    @Nullable
    private GitPushTarget myCurrentTarget;
    @Nullable
    @Nls
    private String myError;
    @Nullable
    private Runnable myFireOnChangeAction;
    private boolean myBranchWasUpdatedManually;
    private boolean myEventFromRemoteChooser;

    public GitPushTargetPanel(@NotNull GitPushSupport support, @NotNull GitRepository repository2, @Nullable GitPushTarget defaultTarget) {
        if (support == null) {
            GitPushTargetPanel.$$$reportNull$$$0(0);
        }
        if (repository2 == null) {
            GitPushTargetPanel.$$$reportNull$$$0(1);
        }
        this(support, repository2, Objects.requireNonNull(support.getSource(repository2)), defaultTarget);
    }

    public GitPushTargetPanel(@NotNull GitPushSupport support, @NotNull GitRepository repository2, @NotNull GitPushSource source, @Nullable GitPushTarget defaultTarget) {
        if (support == null) {
            GitPushTargetPanel.$$$reportNull$$$0(2);
        }
        if (repository2 == null) {
            GitPushTargetPanel.$$$reportNull$$$0(3);
        }
        if (source == null) {
            GitPushTargetPanel.$$$reportNull$$$0(4);
        }
        this.myPushSupport = support;
        this.myRepository = repository2;
        this.mySource = source;
        this.myGit = Git.getInstance();
        this.myProject = this.myRepository.getProject();
        this.myTargetRenderer = new VcsEditableTextComponent("", null);
        this.myTargetEditor = new PushTargetTextField(repository2.getProject(), GitPushTargetPanel.getTargetNames(this.myRepository), "");
        this.myRemoteRenderer = new VcsLinkedTextComponent("", new VcsLinkListener(){

            public void hyperlinkActivated(@NotNull DefaultMutableTreeNode sourceNode, @NotNull MouseEvent event) {
                if (sourceNode == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (GitPushTargetPanel.this.myRepository.getRemotes().isEmpty()) {
                    GitPushTargetPanel.this.showDefineRemoteDialog();
                } else {
                    Component eventComponent = event.getComponent();
                    if (eventComponent != null) {
                        GitPushTargetPanel.this.showRemoteSelector(eventComponent, event.getPoint());
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "sourceNode";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "git4idea/push/GitPushTargetPanel$1";
                objectArray[2] = "hyperlinkActivated";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.myTargetEditor, "Center");
        if (source instanceof GitPushSource.OnBranch && defaultTarget != null && defaultTarget.getTargetType() == GitPushTargetType.TRACKING_BRANCH && !defaultTarget.isNewBranchCreated()) {
            this.myUpstreamCheckbox = new SetUpstreamCheckbox(defaultTarget.getBranch());
            this.myTargetEditor.addDocumentListener(new DocumentListener(){

                public void documentChanged(@NotNull DocumentEvent event) {
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    GitPushTargetPanel.this.myUpstreamCheckbox.setVisible(GitPushTargetPanel.this.myTargetEditor.getText(), GitPushTargetPanel.this.myRemoteRenderer.getText());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "git4idea/push/GitPushTargetPanel$2", "documentChanged"));
                }
            });
            this.add((Component)((Object)this.myUpstreamCheckbox), "East");
        } else {
            this.myUpstreamCheckbox = null;
        }
        this.updateComponents(defaultTarget);
        this.setFocusCycleRoot(true);
        this.myRemoteRenderer.setFocusable(true);
        this.myTargetEditor.setFocusable(true);
        this.setFocusTraversalPolicy((FocusTraversalPolicy)((Object)new MyGitTargetFocusTraversalPolicy()));
        this.myRemoteRenderer.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (GitPushTargetPanel.this.myTargetEditor.isShowing()) {
                    GitPushTargetPanel.this.showRemoteSelector((Component)GitPushTargetPanel.this.myRemoteRenderer, new Point(GitPushTargetPanel.this.myRemoteRenderer.getLocation()));
                }
            }
        });
        this.setupBranchNameInputValidation(this.myTargetEditor);
        UndoUtil.disableUndoFor((Document)this.myTargetEditor.getDocument());
    }

    private void setupBranchNameInputValidation(@NotNull PushTargetTextField editor2) {
        if (editor2 == null) {
            GitPushTargetPanel.$$$reportNull$$$0(5);
        }
        editor2.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                String targetName = GitPushTargetPanel.this.myTargetEditor.getText();
                String validTargetName = GitRefNameValidator.getInstance().cleanUpBranchNameOnTyping(targetName);
                if (validTargetName.equals(targetName)) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(() -> GitPushTargetPanel.this.myTargetEditor.setText(validTargetName), ModalityState.stateForComponent((Component)GitPushTargetPanel.this.myTargetEditor));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "git4idea/push/GitPushTargetPanel$4", "documentChanged"));
            }
        });
    }

    private void updateComponents(@Nullable GitPushTarget target) {
        this.myCurrentTarget = target;
        boolean noRemotes = this.myRepository.getRemotes().isEmpty();
        if (this.myRepository.isFresh()) {
            this.myError = GitBundle.message("push.dialog.target.panel.empty.repository", new Object[0]);
        } else if (target == null && !noRemotes) {
            this.myError = GitBundle.message("push.dialog.target.panel.can.t.push", new Object[0]);
        }
        String initialBranch = "";
        String initialRemote = "";
        if (target != null) {
            initialBranch = GitPushTargetPanel.getTextFieldText(target);
            initialRemote = target.getBranch().getRemote().getName();
        }
        this.myTargetRenderer.updateLinkText(initialBranch);
        this.myTargetEditor.setText(initialBranch);
        this.myRemoteRenderer.updateLinkText(noRemotes ? GitBundle.message("push.dialog.target.panel.define.remote", new Object[0]) : initialRemote);
        if (this.myUpstreamCheckbox != null) {
            this.myUpstreamCheckbox.setVisible(initialBranch, initialRemote);
        }
        this.myTargetEditor.setVisible(!noRemotes);
    }

    private void showDefineRemoteDialog() {
        GitDefineRemoteDialog dialog = new GitDefineRemoteDialog(this.myRepository, this.myGit, "origin", "");
        if (dialog.showAndGet()) {
            this.addRemoteUnderModal(dialog.getRemoteName(), dialog.getRemoteUrl());
        }
    }

    private void addRemoteUnderModal(final @NotNull String remoteName, final @NotNull String remoteUrl2) {
        if (remoteName == null) {
            GitPushTargetPanel.$$$reportNull$$$0(6);
        }
        if (remoteUrl2 == null) {
            GitPushTargetPanel.$$$reportNull$$$0(7);
        }
        ProgressManager.getInstance().run((Task)new Task.Modal(this.myRepository.getProject(), GitBundle.message("push.dialog.target.panel.adding.remote", new Object[0]), true){
            private GitCommandResult myResult;

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    5.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(true);
                this.myResult = GitPushTargetPanel.this.myGit.addRemote(GitPushTargetPanel.this.myRepository, remoteName, remoteUrl2);
                GitPushTargetPanel.this.myRepository.update();
            }

            public void onSuccess() {
                if (this.myResult.success()) {
                    GitPushTargetPanel.this.updateComponents(GitPushTargetPanel.this.myPushSupport.getDefaultTarget(GitPushTargetPanel.this.myRepository, GitPushTargetPanel.this.mySource));
                    if (GitPushTargetPanel.this.myFireOnChangeAction != null) {
                        GitPushTargetPanel.this.myFireOnChangeAction.run();
                    }
                } else {
                    String message = GitBundle.message("push.dialog.target.panel.couldnt.add.remote", this.myResult.getErrorOutputAsHtmlString());
                    LOG.warn(message);
                    Messages.showErrorDialog((Project)this.myProject, (String)XmlStringUtil.wrapInHtml((CharSequence)message), (String)GitBundle.message("push.dialog.target.panel.add.remote", new Object[0]));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/push/GitPushTargetPanel$5", "run"));
            }
        });
    }

    private void showRemoteSelector(@NotNull Component component2, @NotNull Point point) {
        List<PopupItem> remotes;
        if (component2 == null) {
            GitPushTargetPanel.$$$reportNull$$$0(8);
        }
        if (point == null) {
            GitPushTargetPanel.$$$reportNull$$$0(9);
        }
        if ((remotes = this.getPopupItems()).size() <= 1) {
            return;
        }
        ListPopupImpl popup = new ListPopupImpl(this.myProject, (ListPopupStep)new BaseListPopupStep<PopupItem>(null, remotes){

            public PopupStep<?> onChosen(@NotNull PopupItem selectedValue, boolean finalChoice) {
                if (selectedValue == null) {
                    7.$$$reportNull$$$0(0);
                }
                return this.doFinalStep(() -> {
                    if (selectedValue.isDefineRemote()) {
                        GitPushTargetPanel.this.showDefineRemoteDialog();
                    } else {
                        GitPushTargetPanel.this.myRemoteRenderer.updateLinkText(selectedValue.getPresentable());
                        GitPushTargetPanel.this.myEventFromRemoteChooser = true;
                        if (!GitPushTargetPanel.this.myTargetEditor.isShowing()) {
                            String defaultPushTargetBranch;
                            if (!GitPushTargetPanel.this.myBranchWasUpdatedManually && (defaultPushTargetBranch = GitPushTargetPanel.this.getDefaultPushTargetBranch()) != null) {
                                GitPushTargetPanel.this.myTargetEditor.setText(defaultPushTargetBranch);
                            }
                            if (GitPushTargetPanel.this.myFireOnChangeAction != null) {
                                GitPushTargetPanel.this.myFireOnChangeAction.run();
                            }
                        }
                        GitPushTargetPanel.this.myEventFromRemoteChooser = false;
                    }
                });
            }

            @Nullable
            public ListSeparator getSeparatorAbove(PopupItem value) {
                return value.isDefineRemote() ? new ListSeparator() : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedValue", "git4idea/push/GitPushTargetPanel$7", "onChosen"));
            }
        }){

            public void cancel(InputEvent e) {
                super.cancel(e);
                if (GitPushTargetPanel.this.myTargetEditor.isShowing()) {
                    GitPushTargetPanel.this.repaint();
                    IdeFocusManager.getInstance((Project)GitPushTargetPanel.this.myProject).requestFocus((Component)GitPushTargetPanel.this.myTargetEditor, true);
                }
            }
        };
        popup.show(new RelativePoint(component2, point));
    }

    @Nullable
    private String getDefaultPushTargetBranch() {
        GitPushTarget fromPushSpec;
        GitLocalBranch sourceBranch = this.myRepository.getCurrentBranch();
        GitRemote remote = GitPushTarget.findRemote(this.myRepository.getRemotes(), this.myRemoteRenderer.getText());
        if (remote != null && sourceBranch != null && (fromPushSpec = GitPushTarget.getFromPushSpec(this.myRepository, remote, sourceBranch)) != null) {
            return fromPushSpec.getBranch().getNameForRemoteOperations();
        }
        return null;
    }

    @NotNull
    private List<PopupItem> getPopupItems() {
        ArrayList<PopupItem> items = new ArrayList<PopupItem>(ContainerUtil.map(this.myRepository.getRemotes(), PopupItem::forRemote));
        items.add(PopupItem.DEFINE_REMOTE);
        ArrayList<PopupItem> arrayList = items;
        if (arrayList == null) {
            GitPushTargetPanel.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    public void render(@NotNull ColoredTreeCellRenderer renderer, boolean isSelected, boolean isActive, @Nullable String forceRenderedText) {
        if (renderer == null) {
            GitPushTargetPanel.$$$reportNull$$$0(11);
        }
        SimpleTextAttributes targetTextAttributes = PushLogTreeUtil.addTransparencyIfNeeded((SimpleColoredComponent)renderer, (SimpleTextAttributes)SimpleTextAttributes.REGULAR_ATTRIBUTES, (boolean)isActive);
        if (this.myError != null) {
            renderer.append(this.myError, PushLogTreeUtil.addTransparencyIfNeeded((SimpleColoredComponent)renderer, (SimpleTextAttributes)SimpleTextAttributes.ERROR_ATTRIBUTES, (boolean)isActive));
        } else {
            Collection<GitRemote> remotes = this.myRepository.getRemotes();
            this.myRemoteRenderer.setSelected(isSelected);
            this.myRemoteRenderer.setTransparent(!remotes.isEmpty() && !isActive);
            this.myRemoteRenderer.render(renderer);
            if (!remotes.isEmpty()) {
                boolean newUpstream;
                renderer.append(SEPARATOR, targetTextAttributes);
                if (forceRenderedText != null) {
                    renderer.append(forceRenderedText);
                    return;
                }
                GitPushTarget target = this.getValue();
                boolean newRemoteBranch = target != null && target.isNewBranchCreated();
                this.myTargetRenderer.setSelected(isSelected);
                this.myTargetRenderer.setTransparent(!isActive);
                this.myTargetRenderer.render(renderer);
                GitRemoteBranch targetBranch = target != null ? target.getBranch() : null;
                boolean bl = newUpstream = this.myUpstreamCheckbox != null && targetBranch != null && this.myUpstreamCheckbox.isSelected() && !this.myUpstreamCheckbox.isDefaultUpstream(targetBranch.getNameForRemoteOperations(), targetBranch.getRemote().getName());
                if (newRemoteBranch || newUpstream) {
                    renderer.setIconOnTheRight(true);
                }
                if (newRemoteBranch && newUpstream) {
                    renderer.setIcon((Icon)BranchLabels.getNewAndUpstreamBranchLabel(renderer.getFont(), isSelected));
                } else if (newRemoteBranch) {
                    renderer.setIcon((Icon)BranchLabels.getNewBranchLabel(renderer.getFont(), isSelected));
                } else if (newUpstream) {
                    renderer.setIcon((Icon)BranchLabels.getUpstreamBranchLabel(renderer.getFont(), isSelected));
                }
            }
        }
    }

    @Nullable
    public GitPushTarget getValue() {
        return this.myCurrentTarget;
    }

    @NlsSafe
    @NotNull
    private static String getTextFieldText(@Nullable GitPushTarget target) {
        return target != null ? target.getBranch().getNameForRemoteOperations() : "";
    }

    public void editingStarted() {
        if (this.myUpstreamCheckbox != null) {
            this.myUpstreamCheckbox.setVisible(this.myTargetEditor.getText(), this.myRemoteRenderer.getText());
            this.myUpstreamCheckbox.setEnabled(true);
        }
    }

    public void fireOnCancel() {
        if (this.myUpstreamCheckbox != null) {
            this.myUpstreamCheckbox.setEnabled(false);
        }
        this.myTargetEditor.setText(GitPushTargetPanel.getTextFieldText(this.myCurrentTarget));
    }

    public void fireOnChange() {
        if (this.myUpstreamCheckbox != null) {
            this.myUpstreamCheckbox.setEnabled(false);
        }
        if (this.myError != null || this.myRepository.getRemotes().isEmpty()) {
            return;
        }
        String remoteName = this.myRemoteRenderer.getText();
        String branchName = this.myTargetEditor.getText();
        try {
            GitPushTarget target = GitPushTarget.parse(this.myRepository, remoteName, branchName);
            if (this.myUpstreamCheckbox != null) {
                target.shouldSetNewUpstream(this.myUpstreamCheckbox.isVisible() && this.myUpstreamCheckbox.isSelected());
            }
            if (!target.equals(this.myCurrentTarget)) {
                this.myCurrentTarget = target;
                this.myTargetRenderer.updateLinkText(branchName);
                if (!this.myEventFromRemoteChooser) {
                    this.myBranchWasUpdatedManually = true;
                }
            }
        }
        catch (ParseException e) {
            LOG.error("Invalid remote name shouldn't be allowed. [" + remoteName + ", " + branchName + "]", (Throwable)e);
        }
    }

    @Nullable
    public ValidationInfo verify() {
        if (this.myError != null) {
            return new ValidationInfo(this.myError, (JComponent)this.myTargetEditor);
        }
        try {
            GitPushTarget.parse(this.myRepository, this.myRemoteRenderer.getText(), this.myTargetEditor.getText());
            return null;
        }
        catch (ParseException e) {
            return new ValidationInfo(e.getMessage(), (JComponent)this.myTargetEditor);
        }
    }

    public void setFireOnChangeAction(@NotNull Runnable action) {
        if (action == null) {
            GitPushTargetPanel.$$$reportNull$$$0(12);
        }
        this.myFireOnChangeAction = action;
    }

    @NotNull
    private static List<String> getTargetNames(@NotNull GitRepository repository2) {
        if (repository2 == null) {
            GitPushTargetPanel.$$$reportNull$$$0(13);
        }
        List<String> list = repository2.getBranches().getRemoteBranches().stream().sorted(REMOTE_BRANCH_COMPARATOR).map(GitRemoteBranch::getNameForRemoteOperations).collect(Collectors.toList());
        if (list == null) {
            GitPushTargetPanel.$$$reportNull$$$0(14);
        }
        return list;
    }

    public void addTargetEditorListener(final @NotNull PushTargetEditorListener listener2) {
        if (listener2 == null) {
            GitPushTargetPanel.$$$reportNull$$$0(15);
        }
        this.myTargetEditor.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(0);
                }
                GitPushTargetPanel.this.processActiveUserChanges(listener2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/push/GitPushTargetPanel$8", "documentChanged"));
            }
        });
        this.myTargetEditor.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                GitPushTargetPanel.this.processActiveUserChanges(listener2);
            }
        });
        this.myTargetEditor.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L) {
                    if (GitPushTargetPanel.this.myTargetEditor.isShowing()) {
                        UndoUtil.enableUndoFor((Document)GitPushTargetPanel.this.myTargetEditor.getDocument());
                    } else {
                        UndoUtil.disableUndoFor((Document)GitPushTargetPanel.this.myTargetEditor.getDocument());
                    }
                }
            }
        });
    }

    private void processActiveUserChanges(@NotNull PushTargetEditorListener listener2) {
        if (listener2 == null) {
            GitPushTargetPanel.$$$reportNull$$$0(16);
        }
        if (this.myTargetEditor.isShowing()) {
            listener2.onTargetInEditModeChanged(this.myTargetEditor.getText());
        }
    }

    public void forceUpdateEditableUiModel(@NotNull String forcedText) {
        if (forcedText == null) {
            GitPushTargetPanel.$$$reportNull$$$0(17);
        }
        if (!this.myTargetEditor.isShowing()) {
            this.myTargetEditor.setText(forcedText);
        }
    }

    public boolean showSourceWhenEditing() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "support";
                break;
            }
            case 1: 
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteUrl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/push/GitPushTargetPanel";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forcedText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/push/GitPushTargetPanel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPopupItems";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setupBranchNameInputValidation";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addRemoteUnderModal";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showRemoteSelector";
                break;
            }
            case 10: 
            case 14: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setFireOnChangeAction";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTargetNames";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addTargetEditorListener";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processActiveUserChanges";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "forceUpdateEditableUiModel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 14 -> new IllegalStateException(string);
        };
    }

    private static class SetUpstreamCheckbox
    extends JBCheckBox {
        private final GitRemoteBranch defaultTarget;

        SetUpstreamCheckbox(GitRemoteBranch defaultTarget) {
            super(GitBundle.message("push.dialog.target.panel.upstream.checkbox", new Object[0]), false);
            this.defaultTarget = defaultTarget;
            this.setBorder((Border)JBUI.Borders.empty((int)0, (int)5, (int)0, (int)10));
            this.setOpaque(false);
            this.setFocusable(false);
        }

        public void setVisible(String targetName, String remoteName) {
            boolean valid = GitRefNameValidator.getInstance().checkInput(targetName);
            this.setVisible(valid && !this.isDefaultUpstream(targetName, remoteName));
        }

        public boolean isDefaultUpstream(String targetName, String remoteName) {
            return this.defaultTarget.getNameForRemoteOperations().equals(targetName) && this.defaultTarget.getRemote().getName().equals(remoteName);
        }
    }

    private class MyGitTargetFocusTraversalPolicy
    extends ComponentsListFocusTraversalPolicy {
        private MyGitTargetFocusTraversalPolicy() {
        }

        @NotNull
        protected List<Component> getOrderedComponents() {
            List<VcsLinkedTextComponent> list = List.of(GitPushTargetPanel.this.myTargetEditor.getFocusTarget(), GitPushTargetPanel.this.myRemoteRenderer);
            if (list == null) {
                MyGitTargetFocusTraversalPolicy.$$$reportNull$$$0(0);
            }
            return list;
        }

        public Component getComponentAfter(Container aContainer, Component aComponent) {
            if (GitPushTargetPanel.this.getPopupItems().size() > 1) {
                return super.getComponentAfter(aContainer, aComponent);
            }
            return aComponent;
        }

        public Component getComponentBefore(Container aContainer, Component aComponent) {
            if (GitPushTargetPanel.this.getPopupItems().size() > 1) {
                return super.getComponentBefore(aContainer, aComponent);
            }
            return aComponent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushTargetPanel$MyGitTargetFocusTraversalPolicy", "getOrderedComponents"));
        }
    }

    private static final class PopupItem {
        static final PopupItem DEFINE_REMOTE = new PopupItem(null);
        @Nullable
        GitRemote remote;

        @NotNull
        static PopupItem forRemote(@NotNull GitRemote remote) {
            if (remote == null) {
                PopupItem.$$$reportNull$$$0(0);
            }
            return new PopupItem(remote);
        }

        private PopupItem(@Nullable GitRemote remote) {
            this.remote = remote;
        }

        @Nls
        @NotNull
        String getPresentable() {
            String string = this.remote == null ? GitBundle.message("push.dialog.target.panel.define.remote", new Object[0]) : this.remote.getName();
            if (string == null) {
                PopupItem.$$$reportNull$$$0(1);
            }
            return string;
        }

        boolean isDefineRemote() {
            return this.remote == null;
        }

        public String toString() {
            return this.getPresentable();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "remote";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/push/GitPushTargetPanel$PopupItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/push/GitPushTargetPanel$PopupItem";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "forRemote";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static final class BranchLabels {
        private static final Color LABEL_FG = new JBColor(46397, 7054941);
        private static final Color LABEL_SELECTION_FG = UIUtil.getTreeSelectionForeground();
        private static final Color LABEL_BG = new JBColor(15465713, 3226418);
        private static final Color LABEL_SELECTION_BG = new JBColor(ColorUtil.toAlpha((Color)LABEL_SELECTION_FG, (int)20), ColorUtil.toAlpha((Color)LABEL_SELECTION_FG, (int)30));
        private static final RelativeFont LABEL_FONT = RelativeFont.TINY.small();

        private BranchLabels() {
        }

        public static TextIcon getNewBranchLabel(Font font, boolean selected) {
            return BranchLabels.getLabel(GitBundle.message("push.dialog.target.panel.new", new Object[0]), font, selected);
        }

        public static TextIcon getUpstreamBranchLabel(Font font, boolean selected) {
            return BranchLabels.getLabel(GitBundle.message("push.dialog.target.panel.upstream.label", new Object[0]), font, selected);
        }

        public static TextIcon getNewAndUpstreamBranchLabel(Font font, boolean selected) {
            return BranchLabels.getLabel(GitBundle.message("push.dialog.target.panel.new.and.upstream", new Object[0]), font, selected);
        }

        private static TextIcon getLabel(String text2, Font font, boolean selected) {
            TextIcon label = new TextIcon(text2, LABEL_FG, LABEL_BG, 0);
            label.setInsets((Insets)JBUI.insets((int)2));
            label.setRound(JBUIScale.scale((int)4));
            label.setFont(LABEL_FONT.derive(font));
            label.setForeground(selected ? LABEL_SELECTION_FG : LABEL_FG);
            label.setBackground(selected ? LABEL_SELECTION_BG : LABEL_BG);
            return label;
        }
    }

    private static class MyRemoteBranchComparator
    implements Comparator<GitRemoteBranch> {
        private MyRemoteBranchComparator() {
        }

        @Override
        public int compare(@NotNull GitRemoteBranch o1, @NotNull GitRemoteBranch o2) {
            String remoteName2;
            String remoteName1;
            int remoteComparison;
            if (o1 == null) {
                MyRemoteBranchComparator.$$$reportNull$$$0(0);
            }
            if (o2 == null) {
                MyRemoteBranchComparator.$$$reportNull$$$0(1);
            }
            if ((remoteComparison = (remoteName1 = o1.getRemote().getName()).compareTo(remoteName2 = o2.getRemote().getName())) != 0) {
                if (remoteName1.equals("origin")) {
                    return -1;
                }
                if (remoteName2.equals("origin")) {
                    return 1;
                }
                return remoteComparison;
            }
            return o1.getNameForLocalOperations().compareTo(o2.getNameForLocalOperations());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "o1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "o2";
                    break;
                }
            }
            objectArray[1] = "git4idea/push/GitPushTargetPanel$MyRemoteBranchComparator";
            objectArray[2] = "compare";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

