/* Copyright 2017, NVIDIA CORPORATION.  All rights reserved. */

#ifdef __cplusplus

// Declare all of the __cxa_vec_* routines as OpenACC device routines.
// Use the front end's predefined macro __SIZE_TYPE__ in the place of size_t
// so that nothing else has to be included.

#pragma acc routine seq
extern "C" void __cxa_vec_ctor(void *__array_address,
                               __SIZE_TYPE__ __element_count,
                               __SIZE_TYPE__ __element_size,
                               void (*__constructor)(void *),
                               void (*__destructor)(void *));

#pragma acc routine seq
extern "C" void __cxa_vec_cctor(void *__destination_array,
                                void *__source_array,
                                __SIZE_TYPE__ __element_count,
                                __SIZE_TYPE__ __element_size,
                                void (*__constructor)(void *, void *),
                                void (*__destructor)(void *));

#pragma acc routine seq
extern "C" void __cxa_vec_dtor(void *__array_address,
                               __SIZE_TYPE__ __element_count,
                               __SIZE_TYPE__ __element_size,
                               void (*__destructor)(void *));

#pragma acc routine seq
extern "C" void *__cxa_vec_new(__SIZE_TYPE__ __element_count,
                               __SIZE_TYPE__ __element_size,
                               __SIZE_TYPE__ __padding_size,
                               void (*__constructor)(void *),
                               void (*__destructor)(void *));

#pragma acc routine seq
extern "C" void *__cxa_vec_new2(__SIZE_TYPE__ __element_count,
                                __SIZE_TYPE__ __element_size,
                                __SIZE_TYPE__ __padding_size,
                                void (*__constructor)(void *),
                                void (*__destructor)(void *),
                                void *(*__allocator)(__SIZE_TYPE__),
                                void (*__deallocator)(void *));

#pragma acc routine seq
extern "C" void *__cxa_vec_new3(__SIZE_TYPE__ __element_count,
                                __SIZE_TYPE__ __element_size,
                                __SIZE_TYPE__ __padding_size,
                                void (*__constructor)(void *),
                                void (*__destructor)(void *),
                                void *(*__allocator)(__SIZE_TYPE__),
                                void (*__deallocator)(void *, __SIZE_TYPE__));

#pragma acc routine seq
extern "C" void __cxa_vec_delete(void *__array_address,
                                 __SIZE_TYPE__ __element_size,
                                 __SIZE_TYPE__ __padding_size,
                                 void (*__destructor)(void *));

#pragma acc routine seq
extern "C" void __cxa_vec_delete2(void *__array_address,
                                  __SIZE_TYPE__ __element_size,
                                  __SIZE_TYPE__ __padding_size,
                                  void (*__destructor)(void *),
                                  void (*__deallocator)(void *));

#pragma acc routine seq
extern "C" void __cxa_vec_delete3(void *__array_address,
                                  __SIZE_TYPE__ __element_size,
                                  __SIZE_TYPE__ __padding_size,
                                  void (*__destructor)(void *),
                                  void (*__deallocator)(void *, __SIZE_TYPE__));

#endif /* __cplusplus */
