/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.utils;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.quarkus.vertx.utils.AppendBuffer;
import io.quarkus.vertx.utils.NoBoundChecksBuffer;
import io.quarkus.vertx.utils.VertxJavaIoContext;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Optional;
import org.jboss.logging.Logger;

public class VertxOutputStream
extends OutputStream {
    private static final Logger log = Logger.getLogger((String)"org.jboss.resteasy.reactive.server.vertx.ResteasyReactiveOutputStream");
    private final VertxJavaIoContext context;
    private final HttpServerRequest request;
    private final AppendBuffer appendBuffer;
    private final HttpServerResponse response;
    private boolean committed;
    private boolean closed;
    private boolean waitingForDrain;
    private Throwable throwable;

    public VertxOutputStream(VertxJavaIoContext context) {
        this.context = context;
        this.request = context.getRoutingContext().request();
        this.appendBuffer = AppendBuffer.withMinChunks(context.getMinChunkSize(), context.getOutputBufferCapacity());
        this.response = this.request.response();
        this.response.exceptionHandler((Handler)new Handler<Throwable>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(Throwable event) {
                VertxOutputStream.this.throwable = event;
                log.debugf(event, "IO Exception ", new Object[0]);
                VertxOutputStream.this.request.connection().close();
                HttpConnection httpConnection = VertxOutputStream.this.request.connection();
                synchronized (httpConnection) {
                    if (VertxOutputStream.this.waitingForDrain) {
                        VertxOutputStream.this.request.connection().notifyAll();
                    }
                }
            }
        });
        DrainHandler handler = new DrainHandler(this);
        this.response.drainHandler((Handler)handler);
        this.response.closeHandler((Handler)handler);
        context.getRoutingContext().addEndHandler((Handler)new Handler<AsyncResult<Void>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(AsyncResult<Void> event) {
                HttpConnection httpConnection = VertxOutputStream.this.request.connection();
                synchronized (httpConnection) {
                    if (VertxOutputStream.this.waitingForDrain) {
                        VertxOutputStream.this.request.connection().notifyAll();
                    }
                }
            }
        });
    }

    private Buffer createBuffer(ByteBuf data) {
        return new NoBoundChecksBuffer(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(ByteBuf data, boolean last) throws IOException {
        if (last && data == null) {
            this.response.end((Handler)null);
            return;
        }
        HttpConnection httpConnection = this.request.connection();
        synchronized (httpConnection) {
            try {
                this.awaitWriteable();
                if (last) {
                    if (!this.response.ended()) {
                        this.response.end(this.createBuffer(data), null);
                    }
                } else {
                    this.response.write((Object)this.createBuffer(data), null);
                }
            }
            catch (Exception e) {
                if (data != null && data.refCnt() > 0) {
                    data.release();
                }
                throw new IOException("Failed to write", e);
            }
        }
    }

    private void awaitWriteable() throws IOException {
        if (Context.isOnEventLoopThread()) {
            return;
        }
        assert (Thread.holdsLock(this.request.connection()));
        while (this.response.writeQueueFull()) {
            if (this.throwable != null) {
                throw new IOException(this.throwable);
            }
            if (this.response.closed()) {
                throw new IOException("Connection has been closed");
            }
            try {
                this.waitingForDrain = true;
                this.request.connection().wait();
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException(e.getMessage());
            }
            finally {
                this.waitingForDrain = false;
            }
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len < 1) {
            return;
        }
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        int rem = len;
        int idx = off;
        try {
            while (rem > 0) {
                int written = this.appendBuffer.append(b, idx, rem);
                if (written < rem) {
                    this.writeBlocking(this.appendBuffer.clear(), false);
                }
                rem -= written;
                idx += written;
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void writeBlocking(ByteBuf buffer, boolean finished) throws IOException {
        this.prepareWrite(buffer, finished);
        this.write(buffer, finished);
    }

    private void prepareWrite(ByteBuf buffer, boolean finished) throws IOException {
        if (!this.committed) {
            this.committed = true;
            if (finished) {
                if (!this.response.headWritten()) {
                    if (buffer == null) {
                        this.response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)"0");
                    } else {
                        this.response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)String.valueOf(buffer.readableBytes()));
                    }
                }
            } else {
                Optional<String> contentLength = this.context.getContentLength();
                if (contentLength.isEmpty()) {
                    this.response.setChunked(true);
                } else {
                    this.response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)contentLength.get());
                }
            }
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        try {
            ByteBuf toFlush = this.appendBuffer.clear();
            if (toFlush != null) {
                this.writeBlocking(toFlush, false);
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            this.writeBlocking(this.appendBuffer.clear(), true);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            this.closed = true;
        }
    }

    private record DrainHandler(VertxOutputStream out) implements Handler<Void>
    {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(Void event) {
            HttpConnection httpConnection = this.out.request.connection();
            synchronized (httpConnection) {
                if (this.out.waitingForDrain) {
                    this.out.request.connection().notifyAll();
                }
            }
        }
    }
}

