/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.project;

import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.projectapi.SPIAccessor;
import org.netbeans.modules.projectapi.SimpleFileOwnerQueryImplementation;
import org.netbeans.spi.project.FileOwnerQueryImplementation;
import org.netbeans.spi.project.ProjectManagerImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.Parameters;

public final class ProjectManager {
    private static final Logger LOG = Logger.getLogger(ProjectManager.class.getName());
    private static final ProjectManager DEFAULT = new ProjectManager();
    private final ProjectManagerImplementation impl = (ProjectManagerImplementation)Lookup.getDefault().lookup(ProjectManagerImplementation.class);

    private ProjectManager() {
        if (this.impl == null) {
            throw new IllegalStateException("No ProjectManagerImplementation found in global Lookup.");
        }
        this.impl.init(SPIAccessor.getInstance().createProjectManagerCallBack());
        LOG.log(Level.FINE, "ProjectManager created with implementation: {0}", this.impl);
    }

    @NonNull
    public static ProjectManager getDefault() {
        return DEFAULT;
    }

    @NonNull
    public static Mutex mutex() {
        return ProjectManager.getDefault().impl.getMutex();
    }

    @NonNull
    public static Mutex mutex(boolean autoSave, @NonNull Project project, Project ... otherProjects) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        Parameters.notNull((CharSequence)"otherProjects", (Object)otherProjects);
        return ProjectManager.getDefault().impl.getMutex(autoSave, project, otherProjects);
    }

    @CheckForNull
    public Project findProject(@NonNull FileObject projectDirectory) throws IOException, IllegalArgumentException {
        if (projectDirectory == null) {
            throw new IllegalArgumentException("Attempted to pass a null directory to findProject");
        }
        if (!projectDirectory.isFolder()) {
            throw new IllegalArgumentException("Attempted to pass a non-directory to findProject: " + projectDirectory);
        }
        return this.impl.findProject(projectDirectory);
    }

    public boolean isProject(@NonNull FileObject projectDirectory) throws IllegalArgumentException {
        return this.isProject2(projectDirectory) != null;
    }

    @CheckForNull
    public Result isProject2(@NonNull FileObject projectDirectory) throws IllegalArgumentException {
        if (projectDirectory == null) {
            throw new IllegalArgumentException("Attempted to pass a null directory to isProject");
        }
        if (!projectDirectory.isFolder()) {
            if (projectDirectory.isValid()) {
                throw new IllegalArgumentException("Attempted to pass a non-directory to isProject: " + projectDirectory);
            }
            return null;
        }
        return this.impl.isProject(projectDirectory);
    }

    public void clearNonProjectCache() {
        this.impl.clearNonProjectCache();
        Collection col = Lookup.getDefault().lookupAll(FileOwnerQueryImplementation.class);
        for (FileOwnerQueryImplementation foqi : col) {
            if (!(foqi instanceof SimpleFileOwnerQueryImplementation)) continue;
            ((SimpleFileOwnerQueryImplementation)foqi).resetLastFoundReferences();
        }
    }

    @NonNull
    public Set<Project> getModifiedProjects() {
        return this.impl.getModifiedProjects();
    }

    public boolean isModified(@NonNull Project p) {
        return this.impl.isModified(p);
    }

    public void saveProject(@NonNull Project p) throws IOException {
        Parameters.notNull((CharSequence)"p", (Object)p);
        this.impl.saveProject(p);
    }

    public void saveAllProjects() throws IOException {
        this.impl.saveAllProjects();
    }

    public boolean isValid(@NonNull Project p) {
        Parameters.notNull((CharSequence)"p", (Object)p);
        return this.impl.isValid(p);
    }

    public static final class Result {
        private final Icon icon;
        private final String displayName;
        private final String projectType;

        public Result(Icon icon) {
            this(null, null, icon);
        }

        public Result(String displayName, String projectType, Icon icon) {
            this.icon = icon;
            this.displayName = displayName;
            this.projectType = projectType;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getProjectType() {
            return this.projectType;
        }

        public Icon getIcon() {
            return this.icon;
        }
    }
}

