/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.dialog;

import com.paterva.maltego.util.ui.dialog.ProgressController;
import java.awt.CardLayout;
import java.awt.Component;
import javax.swing.JPanel;
import org.openide.WizardDescriptor;

public abstract class PassFailProgressController<TResult, TPass extends Component, TFail extends Component>
extends ProgressController<TResult, JPanel> {
    private static final int BUSY = 0;
    private static final int PASSED = 1;
    private static final int FAILED = -1;
    private TPass _success;
    private TFail _failure;
    private String _failureMessage;
    private int _status = 0;
    private boolean _allowBackOnFail = true;
    private boolean _allowBackOnPass = false;

    protected TFail failureComponent() {
        return this._failure;
    }

    protected TPass successComponent() {
        return this._success;
    }

    @Override
    protected JPanel createDisplayComponent() {
        this._success = this.createPassComponent();
        this._failure = this.createFailComponent();
        JPanel panel = new JPanel(new CardLayout());
        panel.add((Component)this._success, "success");
        panel.add((Component)this._failure, "failure");
        return panel;
    }

    @Override
    protected String getFirstError(Component component) {
        String e = super.getFirstError(component);
        if (e == null) {
            e = this.getFailureMessage();
        }
        return e;
    }

    protected String getFailureMessage() {
        return this._failureMessage;
    }

    protected abstract TPass createPassComponent();

    protected abstract TFail createFailComponent();

    @Override
    protected void processingCompleted(WizardDescriptor descriptor, JPanel component, TResult result) {
        this._status = 1;
        this._failureMessage = null;
        this.pass(descriptor, this._success, result);
        ((CardLayout)component.getLayout()).show(component, "success");
        this.doValidate();
        this.fireNavigationChanged();
    }

    protected abstract void pass(WizardDescriptor var1, TPass var2, TResult var3);

    protected abstract void fail(TFail var1, Exception var2);

    @Override
    protected void processingFailed(JPanel component, Exception e) {
        this._status = -1;
        this._failureMessage = e.getMessage();
        this.fail(this._failure, e);
        ((CardLayout)component.getLayout()).show(component, "failure");
        this.doValidate();
        this.fireNavigationChanged();
    }

    public boolean allowBackOnPass() {
        return this._allowBackOnPass;
    }

    public boolean allowBackOnFail() {
        return this._allowBackOnFail;
    }

    public void allowBackOnPass(boolean value) {
        this._allowBackOnPass = value;
    }

    public void allowBackOnFail(boolean value) {
        this._allowBackOnFail = value;
    }

    private boolean hasPassed() {
        return this._status == 1;
    }

    private boolean hasFailed() {
        return this._status == -1;
    }

    @Override
    public boolean canBack() {
        boolean s = super.canBack();
        if (s) {
            if (this.hasPassed()) {
                return this.allowBackOnPass();
            }
            if (this.hasFailed()) {
                return this.allowBackOnFail();
            }
        }
        return s;
    }
}

