/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.dialog;

import com.bulenkov.iconloader.util.GraphicsUtil;
import com.paterva.maltego.util.ui.dialog.FullScreenManager;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import org.openide.windows.WindowManager;

public class DefaultFullScreenManager
extends FullScreenManager {
    private JDialog _dialog;
    private Runnable _exitCallback;
    private boolean _isFullScreen;
    private JComponent _component;
    private Container _parent;

    private void closeDialog() {
        if (this._dialog != null) {
            this._dialog.setVisible(false);
            this._dialog.dispose();
        }
        this._dialog = null;
    }

    private void createDialog() {
        Frame mainWindow = WindowManager.getDefault().getMainWindow();
        this._dialog = new JDialog(mainWindow, true);
        this._dialog.setResizable(false);
        if (!this._dialog.isDisplayable()) {
            if (!GraphicsUtil.useCustomLafFrameDecorations((boolean)false)) {
                this._dialog.setUndecorated(true);
            } else {
                this._dialog.getRootPane().setWindowDecorationStyle(0);
            }
        }
        this._dialog.getContentPane().setLayout(new BorderLayout());
        GraphicsConfiguration gfxConfig = mainWindow.getGraphicsConfiguration();
        Rectangle bounds = this.getUsableBounds(gfxConfig);
        this._dialog.setBounds(bounds);
        this._dialog.getRootPane().putClientProperty("SeparateWindow", "true");
    }

    private Rectangle getUsableBounds(GraphicsConfiguration gfxConfig) {
        Rectangle bounds = gfxConfig.getBounds();
        if (!System.getProperty("os.name").toLowerCase().contains("windows")) {
            Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(gfxConfig);
            bounds = new Rectangle(bounds.x + screenInsets.left, bounds.y + screenInsets.top, bounds.width - (screenInsets.left + screenInsets.right), bounds.height - (screenInsets.top + screenInsets.bottom));
        }
        return bounds;
    }

    private void showDialog() {
        this._dialog.setVisible(true);
    }

    private void addEscapeListener(JComponent component) {
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        component.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultFullScreenManager.this.exitFullScreen();
            }
        }, stroke, 2);
    }

    @Override
    public void setFullScreen(JComponent component, Runnable exitCallback) {
        if (this._isFullScreen) {
            this.exitFullScreen();
        }
        this.createDialog();
        this._isFullScreen = true;
        this.firePropertyChanged("fullScreenModeChanged", Boolean.FALSE, Boolean.TRUE);
        this._exitCallback = exitCallback;
        this._component = component;
        this._parent = component.getParent();
        if (this._parent != null) {
            this._parent.remove(component);
        }
        this._dialog.getRootPane().setContentPane(component);
        this.addEscapeListener(component);
        this.showDialog();
    }

    @Override
    public boolean isFullScreen() {
        return this._isFullScreen;
    }

    @Override
    public void exitFullScreen() {
        if (!this.isFullScreen()) {
            return;
        }
        this.closeDialog();
        if (this._exitCallback != null) {
            this._exitCallback.run();
            this._exitCallback = null;
        }
        if (this._parent != null) {
            this._parent.add(this._component);
            this._parent.validate();
            this._parent.repaint();
            this._parent = null;
        }
        this._component = null;
        this._isFullScreen = false;
        this.firePropertyChanged("fullScreenModeChanged", Boolean.TRUE, Boolean.FALSE);
    }

    @Override
    Window getFullScreenWindow() {
        return this._dialog;
    }
}

