/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.InternalSlotId;

public final class JSFrameUtil {
    public static final MaterializedFrame NULL_MATERIALIZED_FRAME = Truffle.getRuntime().createMaterializedFrame(JSArguments.createNullArguments());
    public static final Object DEFAULT_VALUE = Undefined.instance;
    private static final String THIS_SLOT_ID = "<this>";
    private static final Class<? extends MaterializedFrame> MATERIALIZED_FRAME_CLASS = NULL_MATERIALIZED_FRAME.getClass();
    private static final int IS_LET = 1;
    private static final int IS_CONST = 2;
    private static final int HAS_TDZ = 3;
    private static final int IS_HOISTABLE_DECLARATION = 256;
    private static final int IS_IMPORT_BINDING = 16384;
    private static final int IS_PRIVATE_NAME_STATIC = 262144;
    private static final int IS_PRIVATE_METHOD_OR_ACCESSOR = 0x180000;
    private static final int IS_PARAM = 16;
    private static final int IS_ARGUMENTS = 0x200000;
    public static final int SYMBOL_FLAG_MASK = 3948819;

    private JSFrameUtil() {
    }

    public static Object getThisObj(Frame frame) {
        return JSArguments.getThisObject(frame.getArguments());
    }

    public static JSFunctionObject getFunctionObject(Frame frame) {
        return (JSFunctionObject.Unbound)((Object)JSArguments.getFunctionObject(frame.getArguments()));
    }

    public static Object getFunctionObjectNoCast(Frame frame) {
        return JSArguments.getFunctionObject(frame.getArguments());
    }

    public static Object[] getArgumentsArray(Frame frame) {
        return JSArguments.extractUserArguments(frame.getArguments());
    }

    public static int getFlags(FrameSlot frameSlot) {
        return frameSlot.getInfo() instanceof Integer ? (Integer)frameSlot.getInfo() : 0;
    }

    public static boolean hasTemporalDeadZone(FrameSlot frameSlot) {
        return (JSFrameUtil.getFlags(frameSlot) & 3) != 0;
    }

    public static boolean needsTemporalDeadZoneCheck(FrameSlot frameSlot, int frameLevel) {
        return JSFrameUtil.hasTemporalDeadZone(frameSlot) && frameLevel != 0;
    }

    public static boolean isConst(FrameSlot frameSlot) {
        return (JSFrameUtil.getFlags(frameSlot) & 2) != 0;
    }

    public static boolean isLet(FrameSlot frameSlot) {
        return (JSFrameUtil.getFlags(frameSlot) & 1) != 0;
    }

    public static boolean isHoistable(FrameSlot frameSlot) {
        return (JSFrameUtil.getFlags(frameSlot) & 0x100) != 0;
    }

    public static boolean isImportBinding(FrameSlot frameSlot) {
        return (JSFrameUtil.getFlags(frameSlot) & 0x4000) != 0;
    }

    public static boolean needsPrivateBrandCheck(FrameSlot frameSlot) {
        return (JSFrameUtil.getFlags(frameSlot) & 0x180000) != 0;
    }

    public static boolean isPrivateNameStatic(FrameSlot frameSlot) {
        return (JSFrameUtil.getFlags(frameSlot) & 0x40000) != 0;
    }

    public static boolean isParam(FrameSlot frameSlot) {
        return (JSFrameUtil.getFlags(frameSlot) & 0x10) != 0;
    }

    public static boolean isArguments(FrameSlot frameSlot) {
        return (JSFrameUtil.getFlags(frameSlot) & 0x200000) != 0;
    }

    public static MaterializedFrame getParentFrame(Frame frame) {
        return JSArguments.getEnclosingFrame(frame.getArguments());
    }

    public static MaterializedFrame castMaterializedFrame(Object frame) {
        return MATERIALIZED_FRAME_CLASS.cast(frame);
    }

    public static boolean isInternal(FrameSlot frameSlot) {
        CompilerAsserts.neverPartOfCompilation();
        if (frameSlot.getIdentifier() instanceof String) {
            String name = (String)frameSlot.getIdentifier();
            if (name.startsWith(":")) {
                return true;
            }
            return name.startsWith("<") && name.endsWith(">");
        }
        if (frameSlot.getIdentifier() instanceof InternalSlotId) {
            return true;
        }
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    public static String getPublicName(FrameSlot frameSlot) {
        CompilerAsserts.neverPartOfCompilation();
        Object identifier = frameSlot.getIdentifier();
        if (frameSlot.getIdentifier() instanceof String) {
            String name = (String)frameSlot.getIdentifier();
            if (name.startsWith(":")) {
                return name.substring(1);
            }
            if (name.startsWith("<") && name.endsWith(">")) {
                return name.substring(1, name.length() - 1);
            }
            return name;
        }
        return identifier.toString();
    }

    public static boolean isThisSlot(FrameSlot frameSlot) {
        return frameSlot.getIdentifier().equals(THIS_SLOT_ID);
    }

    public static FrameSlot getThisSlot(FrameDescriptor frameDescriptor) {
        return frameDescriptor.findFrameSlot((Object)THIS_SLOT_ID);
    }
}

