/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.convert;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.paterva.maltego.typing.convert.StringConverter;
import com.paterva.maltego.util.StringUtilities;

public class DefaultJsonConverter
implements StringConverter {
    private final ObjectMapper mapper = new ObjectMapper();
    private static DefaultJsonConverter _default;

    public static DefaultJsonConverter getInstance() {
        if (_default == null) {
            _default = new DefaultJsonConverter();
        }
        return _default;
    }

    @Override
    public Object convertFrom(String value, Class to) throws IllegalArgumentException {
        if (String.class.equals((Object)to)) {
            return value;
        }
        if (StringUtilities.isNullOrEmpty((String)value)) {
            return null;
        }
        if (String[].class.equals((Object)to)) {
            value = this.ensureJsonArrayFormat(value);
        }
        try {
            return this.mapper.readValue(value, to);
        }
        catch (JsonProcessingException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    public String convertTo(Object value, Class from) throws IllegalArgumentException {
        if (value == null) {
            return null;
        }
        try {
            return this.mapper.writeValueAsString(value);
        }
        catch (JsonProcessingException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private String ensureJsonArrayFormat(String value) {
        if (!value.startsWith("[") && !value.endsWith("]")) {
            String escapedValue = this.escapeJsonValue(value);
            return String.format("[\"%s\"]", escapedValue);
        }
        return value;
    }

    private String escapeJsonValue(String value) {
        return value.replace("\"", "\\\"");
    }
}

