/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.renderer.BaseElementRenderable;
import org.lobobrowser.html.renderer.BoundableRenderable;
import org.lobobrowser.html.renderer.DelayedPair;
import org.lobobrowser.html.renderer.FrameContext;
import org.lobobrowser.html.renderer.PositionedRenderable;
import org.lobobrowser.html.renderer.RUIControl;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.html.renderer.TableMatrix;
import org.lobobrowser.html.renderer.ZIndexComparator;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.util.Objects;

class RTable
extends BaseElementRenderable {
    private static final int MAX_CACHE_SIZE = 10;
    private final Map cachedLayout = new HashMap(5);
    private final TableMatrix tableMatrix;
    private SortedSet positionedRenderables;
    private int otherOrdinal;
    private LayoutKey lastLayoutKey = null;
    private LayoutValue lastLayoutValue = null;

    public RTable(HTMLElementImpl modelNode, UserAgentContext pcontext, HtmlRendererContext rcontext, FrameContext frameContext, RenderableContainer container) {
        super(container, modelNode, pcontext);
        this.tableMatrix = new TableMatrix(modelNode, pcontext, rcontext, frameContext, this, this);
    }

    @Override
    public int getVAlign() {
        return 5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        RenderState rs = this.modelNode.getRenderState();
        if (rs != null && rs.getVisibility() != 0) {
            return;
        }
        try {
            this.prePaint(g);
            Dimension size = this.getSize();
            TableMatrix tm = this.tableMatrix;
            tm.paint(g, size);
            SortedSet prs = this.positionedRenderables;
            if (prs != null) {
                for (PositionedRenderable pr : prs) {
                    BoundableRenderable r = pr.renderable;
                    r.paintTranslated(g);
                }
            }
        }
        finally {
            super.paint(g);
        }
    }

    @Override
    public void doLayout(int availWidth, int availHeight, boolean sizeOnly) {
        Map cachedLayout = this.cachedLayout;
        RenderState rs = this.modelNode.getRenderState();
        int whitespace = rs == null ? 0 : rs.getWhiteSpace();
        Font font = rs == null ? null : rs.getFont();
        LayoutKey layoutKey = new LayoutKey(availWidth, availHeight, whitespace, font);
        LayoutValue layoutValue = sizeOnly ? (LayoutValue)cachedLayout.get(layoutKey) : (Objects.equals(layoutKey, this.lastLayoutKey) ? this.lastLayoutValue : null);
        if (layoutValue == null) {
            SortedSet prs = this.positionedRenderables;
            if (prs != null) {
                prs.clear();
            }
            this.otherOrdinal = 0;
            this.clearGUIComponents();
            this.clearDelayedPairs();
            this.applyStyle(availWidth, availHeight);
            TableMatrix tm = this.tableMatrix;
            Insets insets = this.getInsets(false, false);
            tm.reset(insets, availWidth, availHeight);
            tm.build(availWidth, availHeight, sizeOnly);
            tm.doLayout(insets);
            Collection pairs = this.delayedPairs;
            if (pairs != null) {
                for (DelayedPair pair : pairs) {
                    if (pair.targetParent != this) continue;
                    this.importDelayedPair(pair);
                }
            }
            layoutValue = new LayoutValue(tm.getTableWidth(), tm.getTableHeight());
            if (sizeOnly) {
                if (cachedLayout.size() > 10) {
                    cachedLayout.clear();
                }
                cachedLayout.put(layoutKey, layoutValue);
                this.lastLayoutKey = null;
                this.lastLayoutValue = null;
            } else {
                this.lastLayoutKey = layoutKey;
                this.lastLayoutValue = layoutValue;
            }
        }
        this.width = layoutValue.width;
        this.height = layoutValue.height;
        this.sendGUIComponentsToParent();
        this.sendDelayedPairsToParent();
    }

    @Override
    public void invalidateLayoutLocal() {
        super.invalidateLayoutLocal();
        this.cachedLayout.clear();
        this.lastLayoutKey = null;
        this.lastLayoutValue = null;
    }

    @Override
    public RenderableSpot getLowestRenderableSpot(int x, int y) {
        RenderableSpot rs;
        SortedSet prs = this.positionedRenderables;
        if (prs != null) {
            for (PositionedRenderable pr : prs) {
                int childY;
                BoundableRenderable r = pr.renderable;
                int childX = x - r.getX();
                RenderableSpot rs2 = r.getLowestRenderableSpot(childX, childY = y - r.getY());
                if (rs2 == null) continue;
                return rs2;
            }
        }
        if ((rs = this.tableMatrix.getLowestRenderableSpot(x, y)) != null) {
            return rs;
        }
        return new RenderableSpot(this, x, y);
    }

    @Override
    public boolean onMouseClick(MouseEvent event, int x, int y) {
        SortedSet prs = this.positionedRenderables;
        if (prs != null) {
            for (PositionedRenderable pr : prs) {
                int childY;
                int childX;
                BoundableRenderable r = pr.renderable;
                Rectangle bounds = r.getBounds();
                if (!bounds.contains(x, y) || r.onMouseClick(event, childX = x - r.getX(), childY = y - r.getY())) continue;
                return false;
            }
        }
        return this.tableMatrix.onMouseClick(event, x, y);
    }

    @Override
    public boolean onDoubleClick(MouseEvent event, int x, int y) {
        SortedSet prs = this.positionedRenderables;
        if (prs != null) {
            for (PositionedRenderable pr : prs) {
                int childY;
                int childX;
                BoundableRenderable r = pr.renderable;
                Rectangle bounds = r.getBounds();
                if (!bounds.contains(x, y) || r.onDoubleClick(event, childX = x - r.getX(), childY = y - r.getY())) continue;
                return false;
            }
        }
        return this.tableMatrix.onDoubleClick(event, x, y);
    }

    @Override
    public boolean onMouseDisarmed(MouseEvent event) {
        return this.tableMatrix.onMouseDisarmed(event);
    }

    @Override
    public boolean onMousePressed(MouseEvent event, int x, int y) {
        SortedSet prs = this.positionedRenderables;
        if (prs != null) {
            for (PositionedRenderable pr : prs) {
                int childY;
                int childX;
                BoundableRenderable r = pr.renderable;
                Rectangle bounds = r.getBounds();
                if (!bounds.contains(x, y) || r.onMousePressed(event, childX = x - r.getX(), childY = y - r.getY())) continue;
                return false;
            }
        }
        return this.tableMatrix.onMousePressed(event, x, y);
    }

    @Override
    public boolean onMouseReleased(MouseEvent event, int x, int y) {
        SortedSet prs = this.positionedRenderables;
        if (prs != null) {
            for (PositionedRenderable pr : prs) {
                int childY;
                int childX;
                BoundableRenderable r = pr.renderable;
                Rectangle bounds = r.getBounds();
                if (!bounds.contains(x, y) || r.onMouseReleased(event, childX = x - r.getX(), childY = y - r.getY())) continue;
                return false;
            }
        }
        return this.tableMatrix.onMouseReleased(event, x, y);
    }

    @Override
    public Iterator getRenderables() {
        SortedSet prs = this.positionedRenderables;
        if (prs != null) {
            LinkedList<BoundableRenderable> c = new LinkedList<BoundableRenderable>();
            for (PositionedRenderable pr : prs) {
                BoundableRenderable r = pr.renderable;
                c.add(r);
            }
            Iterator i2 = this.tableMatrix.getRenderables();
            while (i2.hasNext()) {
                c.add((BoundableRenderable)i2.next());
            }
            return c.iterator();
        }
        return this.tableMatrix.getRenderables();
    }

    @Override
    public void repaint(ModelNode modelNode) {
    }

    @Override
    public Color getPaintedBackgroundColor() {
        return this.container.getPaintedBackgroundColor();
    }

    private final void addPositionedRenderable(BoundableRenderable renderable, boolean verticalAlignable, boolean isFloat) {
        TreeSet<PositionedRenderable> others = this.positionedRenderables;
        if (others == null) {
            this.positionedRenderables = others = new TreeSet<PositionedRenderable>(new ZIndexComparator());
        }
        others.add(new PositionedRenderable(renderable, verticalAlignable, this.otherOrdinal++, isFloat));
        renderable.setParent(this);
        if (renderable instanceof RUIControl) {
            this.container.addComponent(((RUIControl)renderable).widget.getComponent());
        }
    }

    private void importDelayedPair(DelayedPair pair) {
        BoundableRenderable r = pair.child;
        r.setOrigin(pair.x, pair.y);
        this.addPositionedRenderable(r, false, false);
    }

    public String toString() {
        return "RTable[this=" + System.identityHashCode(this) + ",node=" + this.modelNode + "]";
    }

    private static class LayoutValue {
        public final int width;
        public final int height;

        public LayoutValue(int width, int height) {
            this.width = width;
            this.height = height;
        }
    }

    private static class LayoutKey {
        public final int availWidth;
        public final int availHeight;
        public final int whitespace;
        public final Font font;

        public LayoutKey(int availWidth, int availHeight, int whitespace, Font font) {
            this.availWidth = availWidth;
            this.availHeight = availHeight;
            this.whitespace = whitespace;
            this.font = font;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof LayoutKey)) {
                return false;
            }
            LayoutKey other = (LayoutKey)obj;
            return other.availWidth == this.availWidth && other.availHeight == this.availHeight && other.whitespace == this.whitespace && Objects.equals(other.font, this.font);
        }

        public int hashCode() {
            Font font = this.font;
            return this.availWidth * 1000 + this.availHeight ^ (font == null ? 0 : font.hashCode());
        }
    }
}

