/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.java.config.jre;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;

public class FileProxy {
    private static final String RESOURCE_SCHEME = "resource";
    private static Map<URI, File> _cache = new HashMap<URI, File>();

    public static File getFile(String uri) {
        try {
            URI myUri = new URI(uri);
            return FileProxy.getFile(myUri);
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getFile(URI uri) {
        File file = _cache.get(uri);
        if (file == null) {
            if (uri.getScheme().equals("file")) {
                file = new File(uri);
                if (!file.exists()) {
                    file = null;
                }
            } else if (uri.getScheme().equals(RESOURCE_SCHEME)) {
                OutputStream out = null;
                try {
                    String path = uri.getSchemeSpecificPart();
                    File tempDir = FileProxy.createTempDirectory();
                    file = new File(tempDir, path.substring(path.lastIndexOf(47)));
                    file.createNewFile();
                    file.deleteOnExit();
                    tempDir.deleteOnExit();
                    InputStream resource = FileProxy.class.getClassLoader().getResourceAsStream(path);
                    out = new FileOutputStream(file);
                    if (resource == null) {
                        throw new IllegalStateException("Resource not found: " + path);
                    }
                    FileProxy.transferData(resource, out);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    file = null;
                }
                finally {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            } else {
                throw new IllegalArgumentException("unsupported scheme: " + uri.getScheme());
            }
            if (file != null) {
                System.out.println(uri + " -> " + file.getAbsolutePath());
                _cache.put(uri, file);
            }
        }
        return file;
    }

    public static void transferData(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[65536];
        int length = 0;
        while ((length = in.read(buffer)) != -1) {
            out.write(buffer, 0, length);
        }
        out.flush();
    }

    public static File createTempDirectory() throws IOException {
        File temp = File.createTempFile("temp", Long.toString(System.nanoTime()));
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        return temp;
    }
}

