/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.iconloader.util;

import com.bulenkov.iconloader.util.GraphicsConfig;
import com.bulenkov.iconloader.util.SystemInfo;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.Line2D;
import java.lang.reflect.Field;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class GraphicsUtil {
    private static boolean shouldAntialias() {
        return Boolean.getBoolean("swing.aatext");
    }

    public static void setupTextAntialiasing(Graphics g, JComponent c) {
        GraphicsUtil.setupTextAntialiasing(g, c, false);
    }

    public static void setupTextAntialiasing(Graphics g, JComponent c, boolean ignoreSystemSettings) {
        if (g instanceof Graphics2D) {
            Graphics2D g2D = (Graphics2D)g;
            Toolkit tk = Toolkit.getDefaultToolkit();
            Map map = (Map)tk.getDesktopProperty("awt.font.desktophints");
            if (map != null && !ignoreSystemSettings) {
                g2D.addRenderingHints(map);
            }
            if (c != null && SystemInfo.isJava8()) {
                try {
                    Class<?> swingUtilities2 = Class.forName("sun.swing.SwingUtilities2");
                    Field textProperty = swingUtilities2.getField("AA_TEXT_PROPERTY_KEY");
                    c.putClientProperty(textProperty, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static GraphicsConfig setupAAPainting(Graphics g) {
        GraphicsConfig config = new GraphicsConfig(g);
        Graphics2D g2D = (Graphics2D)g;
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        return config;
    }

    public static GraphicsConfig paintWithAlpha(Graphics g, float alpha) {
        assert (0.0f <= alpha && alpha <= 1.0f) : "alpha should be in range 0.0f .. 1.0f";
        GraphicsConfig config = new GraphicsConfig(g);
        Graphics2D g2D = (Graphics2D)g;
        g2D.setComposite(AlphaComposite.getInstance(3, alpha));
        return config;
    }

    public static void drawLine(Graphics g, double x1, double y1, double x2, double y2) {
        Graphics2D g2D = (Graphics2D)g.create();
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        g2D.setStroke(new BasicStroke(0.2f));
        g2D.draw(new Line2D.Double(x1, y1, x2, y2));
        g2D.dispose();
    }

    public static boolean useCustomLafFrameDecorations(boolean atStartupCheck) {
        boolean value = false;
        UIDefaults laf = UIManager.getLookAndFeelDefaults();
        if (laf.getBoolean("maltego.useCustomLafFrameDecorations") && (SystemInfo.isWindows && laf.getBoolean("maltego.includeWindowsForCustomLafFrameDecorations") || SystemInfo.isMac && laf.getBoolean("maltego.includeMacForCustomLafFrameDecorations") || SystemInfo.isLinux && laf.getBoolean("maltego.includeLinuxForCustomLafFrameDecorations"))) {
            return GraphicsUtil.useCustomLafFrameDecorationsSubCheck(laf, atStartupCheck);
        }
        return value;
    }

    private static boolean useCustomLafFrameDecorationsSubCheck(UIDefaults laf, boolean atStartupCheck) {
        boolean value = true;
        if (!(atStartupCheck && laf.getBoolean("maltego.ignoreDualScreenMonitorCheckForCustomLafFrameDecorationsAtStartup") || !atStartupCheck && laf.getBoolean("maltego.ignoreDualScreenMonitorCheckForCustomLafFrameDecorationsPerpetually"))) {
            try {
                GraphicsDevice[] screenDevices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
                if (screenDevices.length > 1) {
                    value = false;
                }
            }
            catch (HeadlessException ex) {
                value = false;
            }
        }
        return value;
    }
}

