/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.ui.graph.view2d.ExportCookie;
import com.paterva.maltego.ui.graph.view2d.Graph2DExporter;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import yguard.A.J.U;

public class Graph2DViewExporter
implements ExportCookie {
    WeakReference<U> _view;

    public Graph2DViewExporter(U view) {
        this._view = new WeakReference<U>(view);
    }

    private U getView() {
        return this._view != null ? (U)this._view.get() : null;
    }

    @Override
    public Map<String, String> getFileTypes() {
        return Graph2DExporter.getFileTypes();
    }

    @Override
    public void exportToFile(File outImage, int width, boolean wholeGraph, File outHTML) throws IOException {
        U view = this.getView();
        if (view != null) {
            boolean transparentBackground = false;
            if (outImage.getPath().toLowerCase().endsWith(".png")) {
                transparentBackground = true;
            }
            Graph2DExporter.exportToFile(outImage, view.getGraph2D(), transparentBackground, width, wholeGraph, outHTML, null);
        } else {
            Logger.getLogger(Graph2DViewExporter.class.getName()).log(Level.SEVERE, "Cannot export graph, view already released.");
        }
    }
}

