/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.imex;

import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.entity.api.LinkFactory;
import com.paterva.maltego.typing.Converter;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.ui.graph.imex.StaxHelper;
import com.paterva.maltego.util.BulkStatusDisplayer;
import com.paterva.maltego.util.XMLEscapeUtils;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.openide.util.Exceptions;

public class StaxLinkReader {
    private static final Logger LOG = Logger.getLogger(StaxLinkReader.class.getName());
    private final XMLStreamReader _reader;
    private final LinkFactory _factory = LinkFactory.getDefault();
    private final BulkStatusDisplayer _statusDisplayer = new BulkStatusDisplayer("Loading links (%d)");

    public StaxLinkReader(XMLStreamReader reader) {
        this._reader = reader;
    }

    public MaltegoLink readLink() throws IOException, XMLStreamException {
        this._statusDisplayer.increment();
        String type = StaxHelper.getRequiredAttribute(this._reader, "type");
        String id = StaxHelper.getOptionalAttribute(this._reader, "id", null);
        String reversed = StaxHelper.getOptionalAttribute(this._reader, "reversed", null);
        LinkID guid = id != null ? LinkID.parse((String)id) : null;
        MaltegoLink link = null;
        do {
            this._reader.next();
            if (link != null || !StaxHelper.isStartElement(this._reader, "Properties")) continue;
            link = guid != null ? this._factory.createInstance(type, guid, false) : this._factory.createInstance(type, false);
            this.attachProperties(link);
            if (reversed == null || !reversed.toLowerCase().equals("true")) continue;
            link.setReversed(Boolean.valueOf(true));
        } while (!StaxHelper.isEndElement(this._reader, "MaltegoLink"));
        return link;
    }

    private void attachProperties(MaltegoLink link) throws XMLStreamException, IOException {
        PropertyDescriptorCollection linkProps = link.getProperties();
        do {
            this._reader.next();
            if (!StaxHelper.isStartElement(this._reader, "Property")) continue;
            String name = StaxHelper.getRequiredAttribute(this._reader, "name");
            PropertyDescriptor pd = linkProps.get(name);
            if (pd == null) {
                String type = StaxHelper.getRequiredAttribute(this._reader, "type");
                TypeDescriptor td = TypeRegistry.getDefault().getType(type);
                if (td == null) {
                    LOG.log(Level.WARNING, "Unknown type in loaded graph: {0}", type);
                } else {
                    String displayName = StaxHelper.getOptionalAttribute(this._reader, "displayName", null);
                    boolean hidden = StaxHelper.getBooleanAttribute(this._reader, "hidden", false);
                    boolean nullable = StaxHelper.getBooleanAttribute(this._reader, "nullable", true);
                    boolean readonly = StaxHelper.getBooleanAttribute(this._reader, "readonly", false);
                    pd = new PropertyDescriptor(td.getType(), name, displayName);
                    pd.setHidden(hidden);
                    pd.setNullable(nullable);
                    pd.setReadonly(readonly);
                    linkProps.add(pd);
                }
            }
            if (pd == null) continue;
            StaxHelper.skipToElement(this._reader, "Value");
            String valueString = XMLEscapeUtils.unescapeUnicode((String)this._reader.getElementText());
            try {
                Object value = Converter.convertFrom((String)valueString, (Class)pd.getType());
                link.setValue(pd, value);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                TypeDescriptor type = TypeRegistry.getDefault().getType(pd.getType());
                if (type == null) continue;
                link.setValue(pd, type.getDefaultValue());
            }
        } while (!StaxHelper.isEndElement(this._reader, "Properties"));
    }
}

