/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.guided.tour.ui;

import com.maltego.guided.tour.TourStep;
import com.maltego.guided.tour.ui.StepNavigationPanel;
import com.maltego.guided.tour.ui.TitlePanel;
import com.maltego.guided.tour.ui.TourDialog;
import com.maltego.guided.tour.ui.TourDialogPresenter;
import com.maltego.guided.tour.ui.TutorialDefaults;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.graph.GraphViewManager;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStoreWriter;
import com.paterva.maltego.graph.wrapper.GraphStoreWriter;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.GraphView;
import com.paterva.maltego.ui.graph.GraphViewCookie;
import com.paterva.maltego.ui.graph.data.GraphDataObject;
import com.paterva.maltego.util.IconSize;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import yguard.A.J.SA;

public class OpenExampleGraphDialog
extends TourDialog {
    private TourStep tourStep = TourStep.DEFAULT;
    private JTextArea contentTextArea;
    private JPanel exampleGraphPanel;
    private StepNavigationPanel navigationPanel;
    private TitlePanel titlePanel;

    public OpenExampleGraphDialog(Frame frame) {
        super(frame);
        this.setMinimumSize(new Dimension(360, 0));
        this.initComponents();
        this.adjustLocation();
        this.getContentPane().setBackground(TutorialDefaults.COLOR_STEP_BACKGROUND);
    }

    @Override
    protected Point getRelativeLocation() {
        Frame parentFrame = this.getParentFrame();
        int x = (parentFrame.getWidth() - this.getWidth()) / 2;
        int y = (parentFrame.getHeight() - this.getHeight()) / 2;
        return new Point(x, y);
    }

    @Override
    public void setTourStep(TourStep tourStep) {
        this.tourStep = tourStep;
        this.titlePanel.setTourStep(tourStep);
        this.titlePanel.setCustomCloseAction(() -> tourStep.next());
        this.navigationPanel.setTourStep(tourStep);
    }

    private void setInteractiveGraphs(List<MaltegoEntitySpec> entryPoints) {
        if (entryPoints.isEmpty()) {
            return;
        }
        this.titlePanel.setTitle(NbBundle.getMessage(OpenExampleGraphDialog.class, (String)"OpenExampleGraphDialog.titlePanel.title_interactive"));
        this.contentTextArea.setText(NbBundle.getMessage(OpenExampleGraphDialog.class, (String)"OpenExampleGraphDialog.contentTextArea.text_interactive"));
        this.contentTextArea.setRows(3);
        this.exampleGraphPanel.removeAll();
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 1));
        JComponent jPanel1Content = panel;
        for (MaltegoEntitySpec spec : entryPoints) {
            if (panel.getComponentCount() == 3) {
                jPanel1Content = this.wrapPanelWithScrollPane(panel);
            }
            JComponent hubSeedComponent = this.createInteractiveGraphComponent(spec);
            panel.add(hubSeedComponent);
        }
        this.exampleGraphPanel.setLayout(new BorderLayout());
        this.exampleGraphPanel.add((Component)jPanel1Content, "Center");
        Dimension size = jPanel1Content.getPreferredSize();
        this.exampleGraphPanel.setPreferredSize(size);
        this.pack();
    }

    private JScrollPane wrapPanelWithScrollPane(JPanel panel) {
        panel.setBorder(BorderFactory.createEmptyBorder(0, 7, 0, 7));
        JScrollPane sp = new JScrollPane(panel);
        sp.setOpaque(false);
        sp.getViewport().setOpaque(false);
        sp.getHorizontalScrollBar().setOpaque(false);
        sp.getVerticalScrollBar().setOpaque(false);
        Dimension size = panel.getPreferredSize();
        size.width = (int)((double)size.width + sp.getVerticalScrollBar().getPreferredSize().getWidth());
        sp.setPreferredSize(size);
        return sp;
    }

    private JComponent createInteractiveGraphComponent(MaltegoEntitySpec spec) {
        JLabel interactiveGraphLabel = new JLabel();
        JButton startInvestigationButton = new JButton();
        interactiveGraphLabel.setFont(interactiveGraphLabel.getFont().deriveFont((float)interactiveGraphLabel.getFont().getSize() + 3.0f));
        Image icon = spec.getIcon(IconSize.MEDIUM.getSize());
        if (icon != null) {
            interactiveGraphLabel.setIcon(new ImageIcon(icon));
        }
        String investigationLabel = NbBundle.getMessage(OpenExampleGraphDialog.class, (String)"OpenExampleGraphDialog.interactiveGraphLabel.text", (Object[])new Object[]{spec.getDisplayName()});
        DisplayDescriptor invNameProperty = spec.getProperties().get("investigation_name");
        if (invNameProperty != null && invNameProperty.getDefaultValue() != null) {
            investigationLabel = invNameProperty.getDefaultValue().toString();
        }
        interactiveGraphLabel.setText(investigationLabel);
        startInvestigationButton.setFont(startInvestigationButton.getFont().deriveFont((float)startInvestigationButton.getFont().getSize() + 3.0f));
        startInvestigationButton.setText(NbBundle.getMessage(OpenExampleGraphDialog.class, (String)"OpenExampleGraphDialog.startInvestigationButton.text"));
        startInvestigationButton.addActionListener(evt -> {
            this.addFirstEntityToInvestigationWhenGraphIsOpened(interactiveGraphLabel.getText(), spec);
            this.openInvestigationGraph();
        });
        JPanel component = new JPanel(new BorderLayout());
        component.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        component.setOpaque(false);
        component.add((Component)interactiveGraphLabel, "West");
        JPanel buttonPanel = new JPanel(new FlowLayout(0));
        buttonPanel.setOpaque(false);
        buttonPanel.add(startInvestigationButton);
        component.add((Component)buttonPanel, "East");
        return component;
    }

    private void openInvestigationGraph() {
        List actionsForPath = Utilities.actionsForPath((String)"Actions/File");
        Optional<Action> newGraphAction = actionsForPath.stream().filter(action -> {
            String name = action.getClass().getSimpleName();
            return name.equals("NewGraphAction");
        }).findFirst();
        newGraphAction.orElseThrow(() -> new IllegalStateException("New Graph needs to be created to go on with the guided tour")).actionPerformed(null);
    }

    public void addFirstEntityToInvestigationWhenGraphIsOpened(final String investigationName, final MaltegoEntitySpec spec) {
        GraphEditorRegistry.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String type = evt.getPropertyName();
                if (!"topmost".equals(type)) {
                    return;
                }
                GraphEditorRegistry.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
                RequestProcessor.getDefault().post(() -> SwingUtilities.invokeLater(() -> {
                    try {
                        TopComponent tc = GraphEditorRegistry.getDefault().getTopmost();
                        GraphDataObject gdo = (GraphDataObject)tc.getLookup().lookup(GraphDataObject.class);
                        String topComponentTitle = NbBundle.getMessage(OpenExampleGraphDialog.class, (String)"OpenExampleGraphDialog.interactiveGraphTopComponent.title", (Object[])new Object[]{investigationName});
                        gdo.renamePrimaryFile(topComponentTitle, false);
                        GraphViewCookie _graphViewCookie = (GraphViewCookie)tc.getLookup().lookup(GraphViewCookie.class);
                        GraphView graphView = _graphViewCookie.getGraphView();
                        SA viewGraph = graphView.getViewGraph();
                        GraphID graphID = GraphViewManager.getDefault().getGraphID(viewGraph);
                        GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
                        GraphDataStoreWriter writer = graphStore.getGraphDataStore().getDataStoreWriter();
                        writer.beginUpdate();
                        viewGraph.\u00cc();
                        EntityFactory entityFactory = EntityFactory.forGraphID((GraphID)graphID);
                        MaltegoEntity entity = entityFactory.createInstance(spec, true, true);
                        entity.setNotes(NbBundle.getMessage(OpenExampleGraphDialog.class, (String)"OpenExampleGraphDialog.entrypointEntity.note", (Object[])new Object[]{spec.getDisplayName()}));
                        entity.setShowNotes(Boolean.TRUE);
                        GraphStoreWriter.addEntity((GraphID)graphID, (MaltegoEntity)entity);
                        viewGraph.D((Object)false);
                        writer.endUpdate();
                        viewGraph.\u00ff();
                    }
                    catch (Exception e) {
                        Exceptions.printStackTrace((Throwable)e);
                    }
                    OpenExampleGraphDialog.this.tourStep.next();
                }), 100, 10);
            }
        });
    }

    private void initComponents() {
        this.titlePanel = new TitlePanel();
        this.contentTextArea = new JTextArea();
        this.navigationPanel = new StepNavigationPanel();
        this.exampleGraphPanel = new JPanel();
        JLabel exampleGraphLabel = new JLabel();
        JButton openGraphButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.titlePanel.setTitle(NbBundle.getMessage(OpenExampleGraphDialog.class, (String)"OpenExampleGraphDialog.titlePanel.title"));
        this.contentTextArea.setEditable(false);
        this.contentTextArea.setColumns(20);
        this.contentTextArea.setFont(this.contentTextArea.getFont().deriveFont((float)this.contentTextArea.getFont().getSize() + 3.0f));
        this.contentTextArea.setLineWrap(true);
        this.contentTextArea.setRows(2);
        this.contentTextArea.setText(NbBundle.getMessage(OpenExampleGraphDialog.class, (String)"OpenExampleGraphDialog.contentTextArea.text"));
        this.contentTextArea.setWrapStyleWord(true);
        this.contentTextArea.setBorder(null);
        this.contentTextArea.setDisabledTextColor(TutorialDefaults.COLOR_TEXT);
        this.contentTextArea.setEnabled(false);
        this.contentTextArea.setOpaque(false);
        this.exampleGraphPanel.setOpaque(false);
        exampleGraphLabel.setFont(exampleGraphLabel.getFont().deriveFont((float)exampleGraphLabel.getFont().getSize() + 3.0f));
        exampleGraphLabel.setIcon(new ImageIcon(this.getClass().getResource("/com/maltego/guided/tour/ui/ico_graph.png")));
        Mnemonics.setLocalizedText((JLabel)exampleGraphLabel, (String)NbBundle.getMessage(OpenExampleGraphDialog.class, (String)"OpenExampleGraphDialog.exampleGraphLabel.text"));
        openGraphButton.setFont(openGraphButton.getFont().deriveFont((float)openGraphButton.getFont().getSize() + 3.0f));
        Mnemonics.setLocalizedText((AbstractButton)openGraphButton, (String)NbBundle.getMessage(OpenExampleGraphDialog.class, (String)"OpenExampleGraphDialog.openGraphButton.text"));
        openGraphButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OpenExampleGraphDialog.this.openGraphButtonActionPerformed(evt);
            }
        });
        GroupLayout exampleGraphPanelLayout = new GroupLayout(this.exampleGraphPanel);
        this.exampleGraphPanel.setLayout(exampleGraphPanelLayout);
        exampleGraphPanelLayout.setHorizontalGroup(exampleGraphPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(exampleGraphPanelLayout.createSequentialGroup().addComponent(exampleGraphLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(openGraphButton)));
        exampleGraphPanelLayout.setVerticalGroup(exampleGraphPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(exampleGraphPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(exampleGraphLabel).addComponent(openGraphButton)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(15, 15, 15).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.exampleGraphPanel, -1, -1, Short.MAX_VALUE).addComponent(this.titlePanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.contentTextArea, GroupLayout.Alignment.LEADING).addComponent(this.navigationPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addGap(15, 15, 15)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.titlePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.contentTextArea, -2, -1, -2).addGap(18, 18, 18).addComponent(this.exampleGraphPanel, -2, -1, -2).addGap(52, 52, 52).addComponent(this.navigationPanel, -2, -1, -2).addContainerGap(15, Short.MAX_VALUE)));
        this.pack();
    }

    private void openGraphButtonActionPerformed(ActionEvent evt) {
        List actionsForPath = Utilities.actionsForPath((String)"Actions/File");
        Optional<Action> exampleGraphAction = actionsForPath.stream().filter(action -> {
            String name = action.getClass().getSimpleName();
            return name.equals("OpenRandomExampleAction");
        }).findFirst();
        exampleGraphAction.orElseThrow(() -> new IllegalStateException("Could not open Example Graph")).actionPerformed(null);
        this.tourStep.next();
    }

    public static class Presenter
    extends TourDialogPresenter<OpenExampleGraphDialog> {
        @Override
        protected OpenExampleGraphDialog createTourDialog(Frame frame) {
            OpenExampleGraphDialog openExampleGraphDialog = new OpenExampleGraphDialog(frame);
            List<MaltegoEntitySpec> entryPoints = this.getInteractiveGraphEntryPoints();
            openExampleGraphDialog.setInteractiveGraphs(entryPoints);
            return openExampleGraphDialog;
        }

        private List<MaltegoEntitySpec> getInteractiveGraphEntryPoints() {
            EntityRegistry registry = EntityRegistry.getDefault();
            Collection specs = registry.getAll();
            List<MaltegoEntitySpec> entryPoints = specs.stream().filter(spec -> {
                String typeName = spec.getTypeName();
                return typeName.startsWith("maltego.onboarding.entrypoint.");
            }).collect(Collectors.toList());
            return entryPoints;
        }
    }
}

