#!/bin/sh

#set -e

do_netmount()
{
	if [ "$NODHCP" = "true" ]
	then
		parsed=$(echo "${STATICIP}" | sed -e 's|,| |g')

		for ifline in ${parsed}
		do
			ifname="$(echo ${ifline} | cut -f1 -d ':')"
			ifaddress="$(echo ${ifline} | cut -f2 -d ':')"
			ifnetmask="$(echo ${ifline} | cut -f3 -d ':')"
			ifgateway="$(echo ${ifline} | cut -f4 -d ':')"
			nameserver="$(echo ${ifline} | cut -f5 -d ':')"
			ip addr add $ifaddress/$ifnetmask dev $ifname
			if [ -n "${ifgateway}" ]
			then
				ip route add default via $ifgateway dev $ifname
			fi
			if [ -n "${nameserver}" ]
			then
				echo "nameserver ${nameserver}" >> "/etc/resolv.conf"
			fi
			ip link set $ifname up
		done
	else
		do_netsetup
	fi

	if [ "${NFSROOT}" = "auto" ]
	then
		NFSROOT=${ROOTSERVER}:${ROOTPATH}
	fi

	rc=1

	if ( [ -n "${FETCH}" ] || [ -n "${HTTPFS}" ] || [ -n "${FTPFS}" ] )
	then
		do_httpmount
		return $?
	fi

	if [ "${NFSROOT#*:}" = "${NFSROOT}" ] && [ "$NETBOOT" != "cifs" ]
	then
		NFSROOT=${ROOTSERVER}:${NFSROOT}
	fi

	log_begin_msg "Trying netboot from ${NFSROOT}"

	if [ "${NETBOOT}" != "nfs" ] && do_cifsmount
	then
		rc=0
	elif do_nfsmount
	then
		NETBOOT="nfs"
		export NETBOOT
		rc=0
	fi

	log_end_msg
	return ${rc}
}
