#!/bin/sh

#set -e

copy_live_to ()
{
	copyfrom="${1}"
	copytodev="${2}"
	copyto="${copyfrom}_swap"

	total_size="0"
	# Only support one module for MODULETORAMFILE, but multiple modules for MODULETORAMDIR because if it's only one file, it's the root file system.
	MODULETORAMDIR=""
	for imtr in ${MODULETORAM//,/ }; do
		if [ -z "${imtr}" ]
		then
			size=$(fs_size "" ${copyfrom}/ "used")
			total_size="$( expr $total_size + $size )"
		elif [ -d "${copyfrom}/${imtr}" ]
		then
			# Directory to be copied
			MDIR="${copyfrom}/${imtr}"
			size=$( expr $(du -sk ${MDIR} | awk '{print $1}') + 5000 )
			total_size="$( expr $total_size + $size )"
			MODULETORAMDIR="$MODULETORAMDIR $MDIR"
		else
			MODULETORAMFILE="${copyfrom}/${LIVE_MEDIA_PATH}/${imtr}"
	
			if [ -f "${MODULETORAMFILE}" ]
			then
				size=$( expr $(ls -la ${MODULETORAMFILE} | awk '{print $5}') / 1024 + 5000 )
				total_size="$( expr $total_size + $size )"
			else
				log_warning_msg "Error: toram-module ${imtr} (${MODULETORAMFILE}) could not be read."
				return 1
			fi
		fi
	done
	
	if [ "${copytodev}" = "ram" ]
	then
		# copying to ram:
		freespace=$(awk '/^MemFree:/{f=$2} /^Cached:/{c=$2} END{print f+c}' /proc/meminfo)
		mount_options="-o size=${total_size}k"
		free_string="memory"
		fstype="tmpfs"
		dev="tmpfs"
	else
		# it should be a writable block device
		if [ -b "${copytodev}" ]
		then
			dev="${copytodev}"
			free_string="space"
			fstype=$(get_fstype "${dev}")
			freespace=$(fs_size "${dev}")
		else
			log_warning_msg "${copytodev} is not a block device."
			return 1
		fi
	fi
	
	if [ "${freespace}" -lt "${total_size}" ]
	then
		log_warning_msg "Not enough free ${free_string} (${freespace}k free, ${total_size}k needed) to copy live media in ${copytodev}."
		return 1
	fi
	
	# Custom ramdisk size
	if [ -z "${mount_options}" ] && [ -n "${ramdisk_size}" ]
	then
		# FIXME: should check for wrong values
		mount_options="-o size=${ramdisk_size}"
	fi
	
	# begin copying (or uncompressing)
	mkdir "${copyto}"
	log_begin_msg "mount -t ${fstype} ${mount_options} ${dev} ${copyto}"
	mount -t "${fstype}" ${mount_options} "${dev}" "${copyto}"
	
	if [ "${extension}" = "tgz" ]
	then
		cd "${copyto}"
		tar zxf "${copyfrom}/${LIVE_MEDIA_PATH}/$(basename ${FETCH})"
		rm -f "${copyfrom}/${LIVE_MEDIA_PATH}/$(basename ${FETCH})"
		mount -r -o move "${copyto}" "${rootmnt}"
		cd "${OLDPWD}"
	else
		if [ -n "${MODULETORAMFILE}" ]
		then
			if [ -x /bin/rsync ]
			then
				echo " * Copying $MODULETORAMFILE to RAM" 1>/dev/console
				rsync -a --progress ${MODULETORAMFILE} ${copyto} 1>/dev/console # copy only the filesystem module
			else
				cp ${MODULETORAMFILE} ${copyto} # copy only the filesystem module
			fi
		elif [ -n "${MODULETORAMDIR}" ]
		then
			if [ -x /bin/rsync ]
			then
				echo " * Copying $MODULETORAMDIR to RAM" 1>/dev/console
				rsync -a --progress ${MODULETORAMDIR} ${copyto} 1>/dev/console # copy only the filesystem module
			else
				cp -a ${MODULETORAMDIR} ${copyto} # copy the whole live directory
			fi
		else
			if [ -x /bin/rsync ]
			then
				echo " * Copying whole medium to RAM" 1>/dev/console
				rsync -a --progress ${copyfrom}/* ${copyto} 1>/dev/console  # "cp -a" from busybox also copies hidden files
			else
				mkdir -p ${copyto}/${LIVE_MEDIA_PATH}
				cp -a ${copyfrom}/${LIVE_MEDIA_PATH}/* ${copyto}/${LIVE_MEDIA_PATH}
				if [ -e ${copyfrom}/${LIVE_MEDIA_PATH}/.disk ]
				then
					cp -a ${copyfrom}/${LIVE_MEDIA_PATH}/.disk ${copyto}
				fi
			fi
		fi
	
		umount ${copyfrom}
		mount -r -o move ${copyto} ${copyfrom}
	fi

	rmdir ${copyto}
	return 0
}
