#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Stellaris expansions (species packs):
# - Plantoids
# - Humanoids
# - Lithoids
# - Necroids
# - Aquatics
# - Toxoids
# send your bug reports to vv221@dotslashplay.it
###

script_version=20250917.1

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='stellaris'
GAME_NAME='Stellaris'

EXPANSION_ID_PLANTOID='plantoid'
EXPANSION_NAME_PLANTOID='Plantoids Species Pack'

EXPANSION_ID_HUMANOIDS='humanoids'
EXPANSION_NAME_HUMANOIDS='Humanoids Species Pack'

EXPANSION_ID_LITHOIDS='lithoids'
EXPANSION_NAME_LITHOIDS='Lithoids Species Pack'

EXPANSION_ID_NECROIDS='necroids'
EXPANSION_NAME_NECROIDS='Necroids Species Pack'

EXPANSION_ID_AQUATICS='aquatics'
EXPANSION_NAME_AQUATICS='Aquatics Species Pack'

EXPANSION_ID_TOXOIDS='toxoids'
EXPANSION_NAME_TOXOIDS='Toxoids Species Pack'

# Archives

## Plantoids

ARCHIVE_BASE_PLANTOID_62_NAME='stellaris_plantoids_species_pack_4_0_23_84679.sh'
ARCHIVE_BASE_PLANTOID_62_MD5='d70d05409ff2c28ed9a770705945d4cc'
ARCHIVE_BASE_PLANTOID_62_SIZE='837'
ARCHIVE_BASE_PLANTOID_62_VERSION='4.0.23-gog84679'
ARCHIVE_BASE_PLANTOID_62_URL='https://www.gog.com/game/stellaris_plantoids_species_pack'

ARCHIVE_BASE_PLANTOID_61_NAME='stellaris_plantoids_species_pack_3_14_1592653_81105.sh'
ARCHIVE_BASE_PLANTOID_61_MD5='f2096d98d49833c1f900cd91b427b99d'
ARCHIVE_BASE_PLANTOID_61_SIZE='837'
ARCHIVE_BASE_PLANTOID_61_VERSION='3.14.1592653-gog81105'

ARCHIVE_BASE_PLANTOID_59_NAME='stellaris_plantoids_species_pack_3_13_2_0_76713.sh'
ARCHIVE_BASE_PLANTOID_59_MD5='3b5da3bbc12bef1778070cb48c0d5b5e'
ARCHIVE_BASE_PLANTOID_59_SIZE='837'
ARCHIVE_BASE_PLANTOID_59_VERSION='3.13.2-gog76713'

ARCHIVE_BASE_PLANTOID_56_NAME='stellaris_plantoids_species_pack_3_12_5_74193.sh'
ARCHIVE_BASE_PLANTOID_56_MD5='c97796440232a0afa39a793efae40c67'
ARCHIVE_BASE_PLANTOID_56_SIZE='837'
ARCHIVE_BASE_PLANTOID_56_VERSION='3.12.5-gog74193'

ARCHIVE_BASE_PLANTOID_52_NAME='stellaris_plantoids_species_pack_3_11_3_0_72561.sh'
ARCHIVE_BASE_PLANTOID_52_MD5='c301172fde38bcd14b9e7546f35e49d2'
ARCHIVE_BASE_PLANTOID_52_SIZE='837'
ARCHIVE_BASE_PLANTOID_52_VERSION='3.11.3-gog72561'

ARCHIVE_BASE_PLANTOID_49_NAME='stellaris_plantoids_species_pack_3_10_4_70670.sh'
ARCHIVE_BASE_PLANTOID_49_MD5='fc70ea7215520e885c61d072463b9be4'
ARCHIVE_BASE_PLANTOID_49_SIZE='837'
ARCHIVE_BASE_PLANTOID_49_VERSION='3.10.4-gog70670'

ARCHIVE_BASE_PLANTOID_43_NAME='stellaris_plantoids_species_pack_3_9_3_68314.sh'
ARCHIVE_BASE_PLANTOID_43_MD5='f38e8c826f876f52cea68b69f85ca079'
ARCHIVE_BASE_PLANTOID_43_SIZE='1156'
ARCHIVE_BASE_PLANTOID_43_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_PLANTOID_40_NAME='stellaris_plantoids_species_pack_3_8_4_1_65337.sh'
ARCHIVE_BASE_PLANTOID_40_MD5='c64fed3a260b17bdb07e439dc20304c7'
ARCHIVE_BASE_PLANTOID_40_SIZE='1200'
ARCHIVE_BASE_PLANTOID_40_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_PLANTOID_39_NAME='stellaris_plantoids_species_pack_3_8_3_1_64953.sh'
ARCHIVE_BASE_PLANTOID_39_MD5='7b0cec949d962b027bc7bd108d79eeaf'
ARCHIVE_BASE_PLANTOID_39_SIZE='1200'
ARCHIVE_BASE_PLANTOID_39_VERSION='3.8.3.1-gog64953'

ARCHIVE_BASE_PLANTOID_36_NAME='stellaris_plantoids_species_pack_3_7_4_63489.sh'
ARCHIVE_BASE_PLANTOID_36_MD5='5a2a9101e09cddc83e29c802b33639ed'
ARCHIVE_BASE_PLANTOID_36_SIZE='1200'
ARCHIVE_BASE_PLANTOID_36_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_PLANTOID_33_NAME='stellaris_plantoids_species_pack_3_6_1_60754.sh'
ARCHIVE_BASE_PLANTOID_33_MD5='298bdd7c0f717f90c2045d0c9a68c1c9'
ARCHIVE_BASE_PLANTOID_33_SIZE='1200'
ARCHIVE_BASE_PLANTOID_33_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_PLANTOID_31_NAME='stellaris_plantoids_species_pack_3_5_3_59410.sh'
ARCHIVE_BASE_PLANTOID_31_MD5='fabc6b9d5580dac6a456da962a765709'
ARCHIVE_BASE_PLANTOID_31_SIZE='1200'
ARCHIVE_BASE_PLANTOID_31_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_PLANTOID_29_NAME='stellaris_plantoids_species_pack_3_4_5_56913.sh'
ARCHIVE_BASE_PLANTOID_29_MD5='b2b5023834509b4a5c2a12bb345380a1'
ARCHIVE_BASE_PLANTOID_29_SIZE='1200'
ARCHIVE_BASE_PLANTOID_29_VERSION='3.4.5-gog56913'

ARCHIVE_BASE_PLANTOID_25_NAME='stellaris_plantoids_species_pack_3_3_4_54421.sh'
ARCHIVE_BASE_PLANTOID_25_MD5='b8ea82b781639c7031ea53d4e155c5d1'
ARCHIVE_BASE_PLANTOID_25_SIZE='1200'
ARCHIVE_BASE_PLANTOID_25_VERSION='3.3.4-gog54421'

ARCHIVE_BASE_PLANTOID_21_NAME='stellaris_plantoids_species_pack_3_2_1_1_51520.sh'
ARCHIVE_BASE_PLANTOID_21_MD5='260d8bc704b93f307d31807efbb5568f'
ARCHIVE_BASE_PLANTOID_21_SIZE='1200'
ARCHIVE_BASE_PLANTOID_21_VERSION='3.2.1.1-gog51520'

ARCHIVE_BASE_PLANTOID_20_NAME='stellaris_plantoids_species_pack_3_1_1_50008.sh'
ARCHIVE_BASE_PLANTOID_20_MD5='fb947af6a98e45645b482a484bd6d42e'
ARCHIVE_BASE_PLANTOID_20_SIZE='1200'
ARCHIVE_BASE_PLANTOID_20_VERSION='3.1.1-gog50008'

ARCHIVE_BASE_PLANTOID_19_NAME='stellaris_plantoids_species_pack_3_0_3_47193.sh'
ARCHIVE_BASE_PLANTOID_19_MD5='d1dc616e45d6d035ed3414687228f95a'
ARCHIVE_BASE_PLANTOID_19_SIZE='1200'
ARCHIVE_BASE_PLANTOID_19_VERSION='3.0.3-gog47193'

## Humanoids

ARCHIVE_BASE_HUMANOIDS_62_NAME='stellaris_humanoids_species_pack_4_0_23_84679.sh'
ARCHIVE_BASE_HUMANOIDS_62_MD5='2f24f9d1cceb67be64f932452c705c34'
ARCHIVE_BASE_HUMANOIDS_62_SIZE='84675'
ARCHIVE_BASE_HUMANOIDS_62_VERSION='4.0.23-gog84679'
ARCHIVE_BASE_HUMANOIDS_62_URL='https://www.gog.com/game/stellaris_humanoids_species_pack'

ARCHIVE_BASE_HUMANOIDS_61_NAME='stellaris_humanoids_species_pack_3_14_1592653_81105.sh'
ARCHIVE_BASE_HUMANOIDS_61_MD5='b0ca9dba864d8726f822b03749cc680c'
ARCHIVE_BASE_HUMANOIDS_61_SIZE='84675'
ARCHIVE_BASE_HUMANOIDS_61_VERSION='3.14.1592653-gog81105'

ARCHIVE_BASE_HUMANOIDS_59_NAME='stellaris_humanoids_species_pack_3_13_2_0_76713.sh'
ARCHIVE_BASE_HUMANOIDS_59_MD5='ae7cc19055d5cdcad0642008cb75bd93'
ARCHIVE_BASE_HUMANOIDS_59_SIZE='84675'
ARCHIVE_BASE_HUMANOIDS_59_VERSION='3.13.2-gog76713'

ARCHIVE_BASE_HUMANOIDS_56_NAME='stellaris_humanoids_species_pack_3_12_5_74193.sh'
ARCHIVE_BASE_HUMANOIDS_56_MD5='f7fa5900c87f3fb8cd43d9dcead97de2'
ARCHIVE_BASE_HUMANOIDS_56_SIZE='116312'
ARCHIVE_BASE_HUMANOIDS_56_VERSION='3.12.5-gog74193'

ARCHIVE_BASE_HUMANOIDS_52_NAME='stellaris_humanoids_species_pack_3_11_3_0_72561.sh'
ARCHIVE_BASE_HUMANOIDS_52_MD5='833ef910df4b00cfb7e3177b7525bee9'
ARCHIVE_BASE_HUMANOIDS_52_SIZE='116312'
ARCHIVE_BASE_HUMANOIDS_52_VERSION='3.11.3-gog72561'

ARCHIVE_BASE_HUMANOIDS_49_NAME='stellaris_humanoids_species_pack_3_10_4_70670.sh'
ARCHIVE_BASE_HUMANOIDS_49_MD5='515dd7f2ae1c68fe53a589f77b7af19c'
ARCHIVE_BASE_HUMANOIDS_49_SIZE='116312'
ARCHIVE_BASE_HUMANOIDS_49_VERSION='3.10.4-gog70670'

ARCHIVE_BASE_HUMANOIDS_43_NAME='stellaris_humanoids_species_pack_3_9_3_68314.sh'
ARCHIVE_BASE_HUMANOIDS_43_MD5='d970689331dfae6ad559b4dd8d146080'
ARCHIVE_BASE_HUMANOIDS_43_SIZE='116636'
ARCHIVE_BASE_HUMANOIDS_43_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_HUMANOIDS_40_NAME='stellaris_humanoids_species_pack_3_8_4_1_65337.sh'
ARCHIVE_BASE_HUMANOIDS_40_MD5='435cdbbe3a8affded29b3b6f9d36125a'
ARCHIVE_BASE_HUMANOIDS_40_SIZE='120000'
ARCHIVE_BASE_HUMANOIDS_40_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_HUMANOIDS_36_NAME='stellaris_humanoids_species_pack_3_7_4_63489.sh'
ARCHIVE_BASE_HUMANOIDS_36_MD5='de7661496eba8a9d125b44f3075a71b7'
ARCHIVE_BASE_HUMANOIDS_36_SIZE='120000'
ARCHIVE_BASE_HUMANOIDS_36_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_HUMANOIDS_33_NAME='stellaris_humanoids_species_pack_3_6_1_60754.sh'
ARCHIVE_BASE_HUMANOIDS_33_MD5='5124b47dce3c7a7282087e521920fee9'
ARCHIVE_BASE_HUMANOIDS_33_SIZE='120000'
ARCHIVE_BASE_HUMANOIDS_33_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_HUMANOIDS_31_NAME='stellaris_humanoids_species_pack_3_5_3_59410.sh'
ARCHIVE_BASE_HUMANOIDS_31_MD5='9f92e8b6853b26bc31da38b5a0991a37'
ARCHIVE_BASE_HUMANOIDS_31_SIZE='120000'
ARCHIVE_BASE_HUMANOIDS_31_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_HUMANOIDS_29_NAME='stellaris_humanoids_species_pack_3_4_5_56913.sh'
ARCHIVE_BASE_HUMANOIDS_29_MD5='5fcd93a54b01f93bae743d49bf61860b'
ARCHIVE_BASE_HUMANOIDS_29_SIZE='120000'
ARCHIVE_BASE_HUMANOIDS_29_VERSION='3.4.5-gog56913'

ARCHIVE_BASE_HUMANOIDS_25_NAME='stellaris_humanoids_species_pack_3_3_4_54421.sh'
ARCHIVE_BASE_HUMANOIDS_25_MD5='b7ccaa9303516274f7945882bd6a2d2f'
ARCHIVE_BASE_HUMANOIDS_25_SIZE='120000'
ARCHIVE_BASE_HUMANOIDS_25_VERSION='3.3.4-gog54421'

ARCHIVE_BASE_HUMANOIDS_21_NAME='stellaris_humanoids_species_pack_3_2_1_1_51520.sh'
ARCHIVE_BASE_HUMANOIDS_21_MD5='d56625b5ce55405530929bea32852f54'
ARCHIVE_BASE_HUMANOIDS_21_SIZE='120000'
ARCHIVE_BASE_HUMANOIDS_21_VERSION='3.2.1.1-gog51520'

ARCHIVE_BASE_HUMANOIDS_20_NAME='stellaris_humanoids_species_pack_3_1_1_50008.sh'
ARCHIVE_BASE_HUMANOIDS_20_MD5='974908ceeb80ade57dfa00c957604d06'
ARCHIVE_BASE_HUMANOIDS_20_SIZE='120000'
ARCHIVE_BASE_HUMANOIDS_20_VERSION='3.1.1-gog50008'

ARCHIVE_BASE_HUMANOIDS_19_NAME='stellaris_humanoids_species_pack_3_0_3_47193.sh'
ARCHIVE_BASE_HUMANOIDS_19_MD5='9dc8511383a7c36c54660d6d77d61117'
ARCHIVE_BASE_HUMANOIDS_19_SIZE='120000'
ARCHIVE_BASE_HUMANOIDS_19_VERSION='3.0.3-gog47193'

## Lithoids

ARCHIVE_BASE_LITHOIDS_50_NAME='stellaris_lithoids_species_pack_4_0_23_84679.sh'
ARCHIVE_BASE_LITHOIDS_50_MD5='15878fe6dfb2d5e9d8828f250666b5b9'
ARCHIVE_BASE_LITHOIDS_50_SIZE='25612'
ARCHIVE_BASE_LITHOIDS_50_VERSION='4.0.23-gog84679'
ARCHIVE_BASE_LITHOIDS_50_URL='https://www.gog.com/game/stellaris_lithoids_species_pack'

ARCHIVE_BASE_LITHOIDS_49_NAME='stellaris_lithoids_species_pack_3_14_1592653_81105.sh'
ARCHIVE_BASE_LITHOIDS_49_MD5='61bc2f350ab85060fa192a4ab9d0449f'
ARCHIVE_BASE_LITHOIDS_49_SIZE='25612'
ARCHIVE_BASE_LITHOIDS_49_VERSION='3.14.1592653-gog81105'

ARCHIVE_BASE_LITHOIDS_47_NAME='stellaris_lithoids_species_pack_3_13_2_0_76713.sh'
ARCHIVE_BASE_LITHOIDS_47_MD5='4fba44ef615444494f99af497e4d2b5f'
ARCHIVE_BASE_LITHOIDS_47_SIZE='25612'
ARCHIVE_BASE_LITHOIDS_47_VERSION='3.13.2-gog76713'

ARCHIVE_BASE_LITHOIDS_44_NAME='stellaris_lithoids_species_pack_3_12_5_74193.sh'
ARCHIVE_BASE_LITHOIDS_44_MD5='bc4810ff3047e688c1ec0ae0991987ae'
ARCHIVE_BASE_LITHOIDS_44_SIZE='52603'
ARCHIVE_BASE_LITHOIDS_44_VERSION='3.12.5-gog74193'

ARCHIVE_BASE_LITHOIDS_40_NAME='stellaris_lithoids_species_pack_3_11_3_0_72561.sh'
ARCHIVE_BASE_LITHOIDS_40_MD5='8ca00268fd2b3b4fb611b65bc2f4edb7'
ARCHIVE_BASE_LITHOIDS_40_SIZE='52603'
ARCHIVE_BASE_LITHOIDS_40_VERSION='3.11.3-gog72561'

ARCHIVE_BASE_LITHOIDS_37_NAME='stellaris_lithoids_species_pack_3_10_4_70670.sh'
ARCHIVE_BASE_LITHOIDS_37_MD5='96caaa7c76349f34823372cc7f9dc769'
ARCHIVE_BASE_LITHOIDS_37_SIZE='52603'
ARCHIVE_BASE_LITHOIDS_37_VERSION='3.10.4-gog70670'

ARCHIVE_BASE_LITHOIDS_31_NAME='stellaris_lithoids_species_pack_3_9_3_68314.sh'
ARCHIVE_BASE_LITHOIDS_31_MD5='baecdaa00168fe891ff419b71334f313'
ARCHIVE_BASE_LITHOIDS_31_SIZE='52924'
ARCHIVE_BASE_LITHOIDS_31_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_LITHOIDS_28_NAME='stellaris_lithoids_species_pack_3_8_4_1_65337.sh'
ARCHIVE_BASE_LITHOIDS_28_MD5='65723d6948a9380c1397b280f9bc20f4'
ARCHIVE_BASE_LITHOIDS_28_SIZE='53000'
ARCHIVE_BASE_LITHOIDS_28_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_LITHOIDS_24_NAME='stellaris_lithoids_species_pack_3_7_4_63489.sh'
ARCHIVE_BASE_LITHOIDS_24_MD5='bfc5632131852032fda229260aa179d6'
ARCHIVE_BASE_LITHOIDS_24_SIZE='53000'
ARCHIVE_BASE_LITHOIDS_24_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_LITHOIDS_21_NAME='stellaris_lithoids_species_pack_3_6_1_60754.sh'
ARCHIVE_BASE_LITHOIDS_21_MD5='0adc3e342f420e26a04b256595eee248'
ARCHIVE_BASE_LITHOIDS_21_SIZE='53000'
ARCHIVE_BASE_LITHOIDS_21_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_LITHOIDS_19_NAME='stellaris_lithoids_species_pack_3_5_3_59410.sh'
ARCHIVE_BASE_LITHOIDS_19_MD5='30bac0aa5302f556fb13511df2e8194b'
ARCHIVE_BASE_LITHOIDS_19_SIZE='53000'
ARCHIVE_BASE_LITHOIDS_19_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_LITHOIDS_17_NAME='stellaris_lithoids_species_pack_3_4_5_56913.sh'
ARCHIVE_BASE_LITHOIDS_17_MD5='54fb17af3ed8b442074c83cf2b818693'
ARCHIVE_BASE_LITHOIDS_17_SIZE='53000'
ARCHIVE_BASE_LITHOIDS_17_VERSION='3.4.5-gog56913'

ARCHIVE_BASE_LITHOIDS_13_NAME='stellaris_lithoids_species_pack_3_3_4_54421.sh'
ARCHIVE_BASE_LITHOIDS_13_MD5='cde1e9ed0deaeff8850242e4157783be'
ARCHIVE_BASE_LITHOIDS_13_SIZE='53000'
ARCHIVE_BASE_LITHOIDS_13_VERSION='3.3.4-gog54421'

ARCHIVE_BASE_LITHOIDS_9_NAME='stellaris_lithoids_species_pack_3_2_1_1_51520.sh'
ARCHIVE_BASE_LITHOIDS_9_MD5='ed5aca5df6d72a84f0572200e1d432fe'
ARCHIVE_BASE_LITHOIDS_9_SIZE='53000'
ARCHIVE_BASE_LITHOIDS_9_VERSION='3.2.1.1-gog51520'

ARCHIVE_BASE_LITHOIDS_8_NAME='stellaris_lithoids_species_pack_3_1_1_50008.sh'
ARCHIVE_BASE_LITHOIDS_8_MD5='c935a54a2e9ac78d195440d7ca1391f9'
ARCHIVE_BASE_LITHOIDS_8_SIZE='53000'
ARCHIVE_BASE_LITHOIDS_8_VERSION='3.1.1-gog50008'

ARCHIVE_BASE_LITHOIDS_7_NAME='stellaris_lithoids_species_pack_3_0_3_47193.sh'
ARCHIVE_BASE_LITHOIDS_7_MD5='44a8e1008468825af82ec138be388fe9'
ARCHIVE_BASE_LITHOIDS_7_SIZE='53000'
ARCHIVE_BASE_LITHOIDS_7_VERSION='3.0.3-gog47193'

## Necroids

ARCHIVE_BASE_NECROIDS_35_NAME='stellaris_necroids_species_pack_4_0_23_84679.sh'
ARCHIVE_BASE_NECROIDS_35_MD5='92999234cfe7eb8b4cb44c4db34d83cb'
ARCHIVE_BASE_NECROIDS_35_SIZE='24881'
ARCHIVE_BASE_NECROIDS_35_VERSION='4.0.23-gog84679'
ARCHIVE_BASE_NECROIDS_35_URL='https://www.gog.com/game/stellaris_necroids_species_pack'

ARCHIVE_BASE_NECROIDS_34_NAME='stellaris_necroids_species_pack_3_14_1592653_81105.sh'
ARCHIVE_BASE_NECROIDS_34_MD5='5725e03dc497001f9837877ea2beff8d'
ARCHIVE_BASE_NECROIDS_34_SIZE='24881'
ARCHIVE_BASE_NECROIDS_34_VERSION='3.14.1592653-gog81105'

ARCHIVE_BASE_NECROIDS_32_NAME='stellaris_necroids_species_pack_3_13_2_0_76713.sh'
ARCHIVE_BASE_NECROIDS_32_MD5='0d3e8d5a8614c7b327584add2c38d13b'
ARCHIVE_BASE_NECROIDS_32_SIZE='24881'
ARCHIVE_BASE_NECROIDS_32_VERSION='3.13.2-gog76713'

ARCHIVE_BASE_NECROIDS_29_NAME='stellaris_necroids_species_pack_3_12_5_74193.sh'
ARCHIVE_BASE_NECROIDS_29_MD5='3df3d9f80ed1d79a2f0f412535b77d54'
ARCHIVE_BASE_NECROIDS_29_SIZE='49209'
ARCHIVE_BASE_NECROIDS_29_VERSION='3.12.5-gog74193'

ARCHIVE_BASE_NECROIDS_25_NAME='stellaris_necroids_species_pack_3_11_3_0_72561.sh'
ARCHIVE_BASE_NECROIDS_25_MD5='d0f677482b688ebe46e0abf20ece8477'
ARCHIVE_BASE_NECROIDS_25_SIZE='49209'
ARCHIVE_BASE_NECROIDS_25_VERSION='3.11.3-gog72561'

ARCHIVE_BASE_NECROIDS_22_NAME='stellaris_necroids_species_pack_3_10_4_70670.sh'
ARCHIVE_BASE_NECROIDS_22_MD5='5549b1dfec82af2de64537ed751a1920'
ARCHIVE_BASE_NECROIDS_22_SIZE='49209'
ARCHIVE_BASE_NECROIDS_22_VERSION='3.10.4-gog70670'

ARCHIVE_BASE_NECROIDS_16_NAME='stellaris_necroids_species_pack_3_9_3_68314.sh'
ARCHIVE_BASE_NECROIDS_16_MD5='8afbc28fb3af625dd145381e44fe7bde'
ARCHIVE_BASE_NECROIDS_16_SIZE='49524'
ARCHIVE_BASE_NECROIDS_16_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_NECROIDS_13_NAME='stellaris_necroids_species_pack_3_8_4_1_65337.sh'
ARCHIVE_BASE_NECROIDS_13_MD5='2614b147a120b97e0d5e4f0a24719f82'
ARCHIVE_BASE_NECROIDS_13_SIZE='50000'
ARCHIVE_BASE_NECROIDS_13_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_NECROIDS_9_NAME='stellaris_necroids_species_pack_3_7_4_63489.sh'
ARCHIVE_BASE_NECROIDS_9_MD5='631269beefca458e901a727af53e09d0'
ARCHIVE_BASE_NECROIDS_9_SIZE='50000'
ARCHIVE_BASE_NECROIDS_9_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_NECROIDS_6_NAME='stellaris_necroids_species_pack_3_6_1_60754.sh'
ARCHIVE_BASE_NECROIDS_6_MD5='13605c18c7d483b3c8abeff2d60c65f7'
ARCHIVE_BASE_NECROIDS_6_SIZE='50000'
ARCHIVE_BASE_NECROIDS_6_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_NECROIDS_4_NAME='stellaris_necroids_species_pack_3_5_3_59410.sh'
ARCHIVE_BASE_NECROIDS_4_MD5='23faec896d52d6f2773e19838f365113'
ARCHIVE_BASE_NECROIDS_4_SIZE='50000'
ARCHIVE_BASE_NECROIDS_4_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_NECROIDS_2_NAME='stellaris_necroids_species_pack_3_4_5_56913.sh'
ARCHIVE_BASE_NECROIDS_2_MD5='e64ecf03e49671cedf3e164709a5837a'
ARCHIVE_BASE_NECROIDS_2_SIZE='50000'
ARCHIVE_BASE_NECROIDS_2_VERSION='3.4.5-gog56913'

## Aquatics

ARCHIVE_BASE_AQUATICS_33_NAME='stellaris_aquatics_species_pack_4_0_23_84679.sh'
ARCHIVE_BASE_AQUATICS_33_MD5='1afeabca087501eae22ce82015866966'
ARCHIVE_BASE_AQUATICS_33_SIZE='29883'
ARCHIVE_BASE_AQUATICS_33_VERSION='4.0.23-gog84679'
ARCHIVE_BASE_AQUATICS_33_URL='https://www.gog.com/game/stellaris_aquatics_species_pack'

ARCHIVE_BASE_AQUATICS_32_NAME='stellaris_aquatics_species_pack_3_14_1592653_81105.sh'
ARCHIVE_BASE_AQUATICS_32_MD5='1eda07287d1d1fe6bf6cefcf2c142d8e'
ARCHIVE_BASE_AQUATICS_32_SIZE='29883'
ARCHIVE_BASE_AQUATICS_32_VERSION='3.14.1592653-gog81105'

ARCHIVE_BASE_AQUATICS_30_NAME='stellaris_aquatics_species_pack_3_13_2_0_76713.sh'
ARCHIVE_BASE_AQUATICS_30_MD5='fc83fab4aa3748870d373f1fe24f0be3'
ARCHIVE_BASE_AQUATICS_30_SIZE='29883'
ARCHIVE_BASE_AQUATICS_30_VERSION='3.13.2-gog76713'

ARCHIVE_BASE_AQUATICS_27_NAME='stellaris_aquatics_species_pack_3_12_5_74193.sh'
ARCHIVE_BASE_AQUATICS_27_MD5='0d9d2d2a38c60025b79e72011b52837c'
ARCHIVE_BASE_AQUATICS_27_SIZE='57544'
ARCHIVE_BASE_AQUATICS_27_VERSION='3.12.5-gog74193'

ARCHIVE_BASE_AQUATICS_23_NAME='stellaris_aquatics_species_pack_3_11_3_0_72561.sh'
ARCHIVE_BASE_AQUATICS_23_MD5='818beaf18d82951df0b1028eb0d7f78a'
ARCHIVE_BASE_AQUATICS_23_SIZE='120876'
ARCHIVE_BASE_AQUATICS_23_VERSION='3.11.3-gog72561'

ARCHIVE_BASE_AQUATICS_20_NAME='stellaris_aquatics_species_pack_3_10_4_70670.sh'
ARCHIVE_BASE_AQUATICS_20_MD5='335d95744fa5467cad87e276fb8d6997'
ARCHIVE_BASE_AQUATICS_20_SIZE='120876'
ARCHIVE_BASE_AQUATICS_20_VERSION='3.10.4-gog70670'

ARCHIVE_BASE_AQUATICS_14_NAME='stellaris_aquatics_species_pack_3_9_3_68314.sh'
ARCHIVE_BASE_AQUATICS_14_MD5='39294019e3f068916fea06f68e35b1ee'
ARCHIVE_BASE_AQUATICS_14_SIZE='121448'
ARCHIVE_BASE_AQUATICS_14_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_AQUATICS_11_NAME='stellaris_aquatics_species_pack_3_8_4_1_65337.sh'
ARCHIVE_BASE_AQUATICS_11_MD5='34a45daa4a4d1bf204dc9798917692b5'
ARCHIVE_BASE_AQUATICS_11_SIZE='130000'
ARCHIVE_BASE_AQUATICS_11_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_AQUATICS_7_NAME='stellaris_aquatics_species_pack_3_7_4_63489.sh'
ARCHIVE_BASE_AQUATICS_7_MD5='f825b3f150a7d936b04b3f5bd35d9f5b'
ARCHIVE_BASE_AQUATICS_7_SIZE='130000'
ARCHIVE_BASE_AQUATICS_7_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_AQUATICS_4_NAME='stellaris_aquatics_species_pack_3_6_1_60754.sh'
ARCHIVE_BASE_AQUATICS_4_MD5='5cfdb2861b8c3de9c83798799b477ad6'
ARCHIVE_BASE_AQUATICS_4_SIZE='130000'
ARCHIVE_BASE_AQUATICS_4_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_AQUATICS_2_NAME='stellaris_aquatics_species_pack_3_5_3_59410.sh'
ARCHIVE_BASE_AQUATICS_2_MD5='7e3210b2d64b851907a97ed3455ad035'
ARCHIVE_BASE_AQUATICS_2_SIZE='130000'
ARCHIVE_BASE_AQUATICS_2_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_AQUATICS_0_NAME='stellaris_aquatics_species_pack_3_4_5_56913.sh'
ARCHIVE_BASE_AQUATICS_0_MD5='0d6fe86d3ec24b114742a333b8de4a3b'
ARCHIVE_BASE_AQUATICS_0_SIZE='130000'
ARCHIVE_BASE_AQUATICS_0_VERSION='3.4.5-gog56913'

## Toxoids

ARCHIVE_BASE_TOXOIDS_26_NAME='stellaris_toxoids_species_pack_4_0_23_84679.sh'
ARCHIVE_BASE_TOXOIDS_26_MD5='5959517aa87e401b89e3dad77fc6fca5'
ARCHIVE_BASE_TOXOIDS_26_SIZE='21991'
ARCHIVE_BASE_TOXOIDS_26_VERSION='4.0.23-gog84679'
ARCHIVE_BASE_TOXOIDS_26_URL='https://www.gog.com/game/stellaris_toxoids_species_pack'

ARCHIVE_BASE_TOXOIDS_25_NAME='stellaris_toxoids_species_pack_3_14_1592653_81105.sh'
ARCHIVE_BASE_TOXOIDS_25_MD5='80a09c9500cd8afa5b1a3b0135a64223'
ARCHIVE_BASE_TOXOIDS_25_SIZE='21991'
ARCHIVE_BASE_TOXOIDS_25_VERSION='3.14.1592653-gog81105'

ARCHIVE_BASE_TOXOIDS_23_NAME='stellaris_toxoids_species_pack_3_13_2_0_76713.sh'
ARCHIVE_BASE_TOXOIDS_23_MD5='a201f70c2f26f9945459e0a9db4a3ea6'
ARCHIVE_BASE_TOXOIDS_23_SIZE='21991'
ARCHIVE_BASE_TOXOIDS_23_VERSION='3.13.2-gog76713'

ARCHIVE_BASE_TOXOIDS_20_NAME='stellaris_toxoids_species_pack_3_12_5_74193.sh'
ARCHIVE_BASE_TOXOIDS_20_MD5='788f0afe85d1f90c91567e3958ddcae1'
ARCHIVE_BASE_TOXOIDS_20_SIZE='41495'
ARCHIVE_BASE_TOXOIDS_20_VERSION='3.12.5-gog74193'

ARCHIVE_BASE_TOXOIDS_16_NAME='stellaris_toxoids_species_pack_3_11_3_0_72561.sh'
ARCHIVE_BASE_TOXOIDS_16_MD5='4dc7bf366e2e84febbe88f77057c018c'
ARCHIVE_BASE_TOXOIDS_16_SIZE='41495'
ARCHIVE_BASE_TOXOIDS_16_VERSION='3.11.3-gog72561'

ARCHIVE_BASE_TOXOIDS_13_NAME='stellaris_toxoids_species_pack_3_10_4_70670.sh'
ARCHIVE_BASE_TOXOIDS_13_MD5='ee41aba19af2f2f91bbe3c156bf614f5'
ARCHIVE_BASE_TOXOIDS_13_SIZE='41495'
ARCHIVE_BASE_TOXOIDS_13_VERSION='3.10.4-gog70670'

ARCHIVE_BASE_TOXOIDS_7_NAME='stellaris_toxoids_species_pack_3_9_3_68314.sh'
ARCHIVE_BASE_TOXOIDS_7_MD5='69ee5d18ffe310c64ee61934ec64aa1f'
ARCHIVE_BASE_TOXOIDS_7_SIZE='41812'
ARCHIVE_BASE_TOXOIDS_7_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_TOXOIDS_4_NAME='stellaris_toxoids_species_pack_3_8_4_1_65337.sh'
ARCHIVE_BASE_TOXOIDS_4_MD5='90926bd74621bf180a074d4721b594f9'
ARCHIVE_BASE_TOXOIDS_4_SIZE='42000'
ARCHIVE_BASE_TOXOIDS_4_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_TOXOIDS_0_NAME='stellaris_toxoids_species_pack_3_7_4_63489.sh'
ARCHIVE_BASE_TOXOIDS_0_MD5='e6af2b93063b67bc78d6a44c70caee1c'
ARCHIVE_BASE_TOXOIDS_0_SIZE='42000'
ARCHIVE_BASE_TOXOIDS_0_VERSION='3.7.4-gog63489'


CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_MAIN_FILES='
dlc'

PKG_PARENT_ID="$GAME_ID"

PKG_MAIN_DEPENDENCIES_SIBLINGS='
PKG_PARENT'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_default

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
