/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl.constant;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.constant.ConstImpl;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.util.Optional;

public final class FloatConst
extends ConstImpl {
    private final float value;

    public FloatConst(float value) {
        super(ConstantDescs.CD_float);
        this.value = value;
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block) {
        int asInt = (int)this.value;
        if (this.value == (float)asInt) {
            switch (asInt) {
                case -5: {
                    cb.iconst_5();
                    cb.ineg();
                    cb.i2f();
                    break;
                }
                case -4: {
                    cb.iconst_4();
                    cb.ineg();
                    cb.i2f();
                    break;
                }
                case -3: {
                    cb.iconst_3();
                    cb.ineg();
                    cb.i2f();
                    break;
                }
                case -2: {
                    cb.iconst_2();
                    cb.ineg();
                    cb.i2f();
                    break;
                }
                case -1: {
                    cb.iconst_m1();
                    cb.i2f();
                    break;
                }
                case 0: {
                    cb.fconst_0();
                    break;
                }
                case 1: {
                    cb.fconst_1();
                    break;
                }
                case 2: {
                    cb.fconst_2();
                    break;
                }
                case 3: {
                    cb.iconst_3();
                    cb.i2f();
                    break;
                }
                case 4: {
                    cb.iconst_4();
                    cb.i2f();
                    break;
                }
                case 5: {
                    cb.iconst_5();
                    cb.i2f();
                    break;
                }
                default: {
                    if (-128 <= asInt && asInt <= 127) {
                        cb.bipush(asInt);
                        cb.i2f();
                        break;
                    }
                    if (Short.MIN_VALUE <= asInt && asInt <= Short.MAX_VALUE) {
                        cb.sipush(asInt);
                        cb.i2f();
                        break;
                    }
                    cb.ldc((ConstantDesc)Float.valueOf(this.value));
                    break;
                }
            }
        } else {
            cb.ldc((ConstantDesc)Float.valueOf(this.value));
        }
    }

    @Override
    public boolean isZero() {
        return this.value == 0.0f;
    }

    @Override
    public boolean isNonZero() {
        return this.value != 0.0f;
    }

    @Override
    public boolean equals(ConstImpl obj) {
        FloatConst other;
        return obj instanceof FloatConst && this.equals(other = (FloatConst)obj);
    }

    public boolean equals(FloatConst other) {
        return this == other || other != null && Float.floatToRawIntBits(this.value) == Float.floatToRawIntBits(other.value);
    }

    @Override
    public int hashCode() {
        return Float.floatToRawIntBits(this.value);
    }

    @Override
    public Float desc() {
        return Float.valueOf(this.value);
    }

    public Optional<Float> describeConstable() {
        return Optional.of(Float.valueOf(this.value));
    }

    @Override
    public StringBuilder toShortString(StringBuilder b) {
        return b.append(this.value).append(" (").append(Float.toHexString(this.value)).append(')');
    }
}

