/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.ssl;

import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.server.ssl.Idle;
import org.jetbrains.idea.maven.server.ssl.MavenTLSCertificateChecker;
import org.jetbrains.idea.maven.server.ssl.State;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\u0010\u001a\u00020\u00112\u000b\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/idea/maven/server/ssl/SslDelegateHandlerStateMachine;", "", "checker", "Lorg/jetbrains/idea/maven/server/ssl/MavenTLSCertificateChecker;", "<init>", "(Lorg/jetbrains/idea/maven/server/ssl/MavenTLSCertificateChecker;)V", "getChecker", "()Lorg/jetbrains/idea/maven/server/ssl/MavenTLSCertificateChecker;", "currentState", "Lorg/jetbrains/idea/maven/server/ssl/State;", "output", "Ljava/io/OutputStream;", "getOutput", "()Ljava/io/OutputStream;", "setOutput", "(Ljava/io/OutputStream;)V", "addLine", "", "text", "", "Lcom/intellij/openapi/util/NlsSafe;", "intellij.maven"})
public class SslDelegateHandlerStateMachine {
    @NotNull
    private final MavenTLSCertificateChecker checker;
    @NotNull
    private State currentState;
    public OutputStream output;

    public SslDelegateHandlerStateMachine(@NotNull MavenTLSCertificateChecker checker) {
        Intrinsics.checkNotNullParameter((Object)checker, (String)"checker");
        this.checker = checker;
        this.currentState = new Idle(this);
    }

    @NotNull
    public final MavenTLSCertificateChecker getChecker() {
        return this.checker;
    }

    @NotNull
    public final OutputStream getOutput() {
        OutputStream outputStream = this.output;
        if (outputStream != null) {
            return outputStream;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"output");
        return null;
    }

    public final void setOutput(@NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"<set-?>");
        this.output = outputStream;
    }

    public final void addLine(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (this.output == null) {
            return;
        }
        char[] cArray = new char[]{'\n', '\r', '\t', ' '};
        this.currentState = this.currentState.addLine(StringsKt.trim((String)text, (char[])cArray));
    }
}

